/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.function.RecipeFunctionArray;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CTShapelessRecipeBase
implements CraftingRecipe {
    private final IIngredient[] ingredients;
    private final IItemStack output;
    @Nullable
    private final RecipeFunctionArray function;
    private final ResourceLocation resourceLocation;

    public CTShapelessRecipeBase(String name, IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunctionArray function) {
        this.resourceLocation = CraftTweakerConstants.rl(name);
        this.output = output;
        this.function = function;
        boolean containsNull = false;
        for (IIngredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.asVanillaIngredient().isEmpty()) continue;
            CraftTweakerAPI.LOGGER.warn("Shapeless recipe with ID '{}' contains null or empty ingredients, removing entries!", (Object)this.resourceLocation);
            containsNull = true;
            break;
        }
        if (containsNull) {
            ingredients = (IIngredient[])Arrays.stream(ingredients).filter(Objects::nonNull).filter(iIngredient -> !iIngredient.asVanillaIngredient().isEmpty()).toArray(IIngredient[]::new);
        }
        this.ingredients = ingredients;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean[] visited = this.forAllUniqueMatches((Container)inv, (ingredientIndex, matchingSlot, stack) -> {});
        int visitedCount = 0;
        for (int slot = 0; slot < visited.length; ++slot) {
            if (visited[slot]) {
                ++visitedCount;
                continue;
            }
            if (inv.getItem(slot).isEmpty()) continue;
            return false;
        }
        return visitedCount == this.ingredients.length;
    }

    public ItemStack assemble(CraftingContainer inv) {
        if (this.function == null) {
            return this.output.getInternal().copy();
        }
        IItemStack[] stacks = new IItemStack[this.ingredients.length];
        this.forAllUniqueMatches((Container)inv, (ingredientIndex, matchingSlot, stack) -> {
            stacks[ingredientIndex] = stack.setAmount(1);
        });
        return this.function.process(this.output, stacks).getImmutableInternal();
    }

    @Nullable
    public RecipeFunctionArray getFunction() {
        return this.function;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.length;
    }

    public ItemStack getResultItem() {
        return this.output.getInternal().copy();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remainingItems = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        this.forAllUniqueMatches((Container)inv, (ingredientIndex, matchingSlot, stack) -> remainingItems.set(matchingSlot, (Object)this.ingredients[ingredientIndex].getRemainingItem(stack).getInternal()));
        return remainingItems;
    }

    private boolean[] forAllUniqueMatches(Container inv, ForAllUniqueAction action) {
        boolean[] visited = new boolean[inv.getContainerSize()];
        block0: for (int ingredientIndex = 0; ingredientIndex < this.ingredients.length; ++ingredientIndex) {
            IIngredient ingredient = this.ingredients[ingredientIndex];
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                IItemStack stack;
                ItemStack stackInSlot;
                if (visited[i] || (stackInSlot = inv.getItem(i)).isEmpty() || !ingredient.matches(stack = Services.PLATFORM.createMCItemStack(stackInSlot))) continue;
                visited[i] = true;
                action.accept(ingredientIndex, i, stack);
                continue block0;
            }
        }
        return visited;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        for (IIngredient ingredient : this.ingredients) {
            ingredients.add((Object)ingredient.asVanillaIngredient());
        }
        return ingredients;
    }

    public String getGroup() {
        return super.getGroup();
    }

    public ResourceLocation getId() {
        return this.resourceLocation;
    }

    public RecipeSerializer<CTShapelessRecipeBase> getSerializer() {
        return Services.REGISTRY.getCTShapelessRecipeSerializer();
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public IIngredient[] getCtIngredients() {
        return this.ingredients;
    }

    public IItemStack getCtOutput() {
        return this.output;
    }

    private static interface ForAllUniqueAction {
        public void accept(int var1, int var2, IItemStack var3);
    }
}

