/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.serializer;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.function.RecipeFunctionMatrix;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipeBase;
import com.blamejared.crafttweaker.platform.Services;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public interface ICTShapedRecipeBaseSerializer
extends RecipeSerializer<CTShapedRecipeBase> {
    default public CTShapedRecipeBase fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
        return this.makeRecipe(CraftTweakerConstants.rl("invalid_recipe"), Services.PLATFORM.createMCItemStack(new ItemStack((ItemLike)Items.BARRIER)), new IIngredient[][]{{Services.PLATFORM.createMCItemStack(new ItemStack((ItemLike)Items.BARRIER))}}, MirrorAxis.NONE, null);
    }

    @Nullable
    default public CTShapedRecipeBase fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int height = buffer.readVarInt();
        int width = buffer.readVarInt();
        IIngredient[][] inputs = new IIngredient[height][width];
        for (int h = 0; h < inputs.length; ++h) {
            for (int w = 0; w < inputs[h].length; ++w) {
                inputs[h][w] = IIngredient.fromIngredient(Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
        }
        MirrorAxis mirrorAxis = (MirrorAxis)buffer.readEnum(MirrorAxis.class);
        ItemStack output = buffer.readItem();
        return this.makeRecipe(recipeId, Services.PLATFORM.createMCItemStack(output), inputs, mirrorAxis, null);
    }

    default public void toNetwork(FriendlyByteBuf buffer, CTShapedRecipeBase recipe) {
        buffer.writeVarInt(recipe.getRecipeHeight());
        buffer.writeVarInt(recipe.getRecipeWidth());
        for (Ingredient ingredient : recipe.getIngredients()) {
            ingredient.toNetwork(buffer);
        }
        buffer.writeEnum((Enum)recipe.getMirrorAxis());
        buffer.writeItem(recipe.getResultItem());
    }

    default public CTShapedRecipeBase makeRecipe(ResourceLocation recipeId, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunctionMatrix function) {
        return new CTShapedRecipeBase(recipeId.getPath(), output, ingredients, mirrorAxis, function);
    }
}

