/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.rule;

import com.blamejared.crafttweaker.api.recipe.handler.ITargetingRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

public final class SpecificRecipesTargetingRule
implements ITargetingRule {
    private final Collection<Recipe<?>> recipes;

    private SpecificRecipesTargetingRule(Collection<Recipe<?>> recipes) {
        this.recipes = Collections.unmodifiableCollection(recipes);
    }

    public static SpecificRecipesTargetingRule of(Collection<Recipe<?>> recipes) {
        if (recipes.isEmpty()) {
            throw new IllegalArgumentException("Unable to create a specific recipes targeting rule without any targets");
        }
        return new SpecificRecipesTargetingRule(recipes);
    }

    public static SpecificRecipesTargetingRule of(Recipe<?> ... recipes) {
        return SpecificRecipesTargetingRule.of(new HashSet(Arrays.asList(recipes)));
    }

    @Override
    public boolean shouldBeReplaced(Recipe<?> recipe, IRecipeManager<?> manager) {
        return this.recipes.stream().anyMatch(it -> it.equals(recipe));
    }

    @Override
    public String describe() {
        return this.recipes.stream().map(Recipe::getId).map(ResourceLocation::toString).collect(Collectors.joining(", ", "recipes {", "}"));
    }

    public Collection<Recipe<?>> recipes() {
        return this.recipes;
    }
}

