/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.rule;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.handler.ITargetingRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.world.item.crafting.Recipe;

public final class OutputTargetingRule
implements ITargetingRule {
    private final IIngredient output;
    private final Collection<IRecipeManager<?>> whitelist;

    private OutputTargetingRule(IIngredient output, Collection<IRecipeManager<?>> whitelist) {
        this.output = output;
        this.whitelist = whitelist;
    }

    public static OutputTargetingRule of(IIngredient output, Collection<IRecipeManager<?>> whitelist) {
        if (output instanceof IItemStack && ((IItemStack)output).isEmpty()) {
            throw new IllegalArgumentException("Unable to create an output target rule for an empty output");
        }
        return new OutputTargetingRule(output, whitelist);
    }

    public static OutputTargetingRule of(IIngredient output, IRecipeManager<?> ... whitelist) {
        return OutputTargetingRule.of(output, new HashSet(Arrays.asList(whitelist)));
    }

    @Override
    public boolean shouldBeReplaced(Recipe<?> recipe, IRecipeManager<?> manager) {
        return this.output.matches(Services.PLATFORM.createMCItemStack(recipe.getResultItem())) && (this.whitelist.isEmpty() || this.whitelist.contains(manager));
    }

    @Override
    public String describe() {
        return String.format("recipes that output %s%s", this.output.getCommandString(), this.stringifyWhitelist());
    }

    private String stringifyWhitelist() {
        if (this.whitelist.isEmpty()) {
            return "";
        }
        return this.whitelist.stream().map(IRecipeManager::getCommandString).collect(Collectors.joining(", ", " in managers {", "}"));
    }
}

