/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.rule;

import com.blamejared.crafttweaker.api.recipe.handler.ITargetingRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

public final class ExcludingRecipesAndDelegatingTargetingRule
implements ITargetingRule {
    private final ITargetingRule delegate;
    private final Collection<ResourceLocation> exclusions;

    private ExcludingRecipesAndDelegatingTargetingRule(ITargetingRule delegate, Collection<ResourceLocation> exclusions) {
        this.delegate = delegate;
        this.exclusions = exclusions;
    }

    public static ExcludingRecipesAndDelegatingTargetingRule of(ITargetingRule delegate, Collection<ResourceLocation> exclusions) {
        Objects.requireNonNull(delegate);
        if (exclusions.isEmpty()) {
            throw new IllegalArgumentException("Unable to create an exclusion for recipes without any recipe to exclude");
        }
        if (delegate instanceof ExcludingRecipesAndDelegatingTargetingRule) {
            ExcludingRecipesAndDelegatingTargetingRule delegatingRule = (ExcludingRecipesAndDelegatingTargetingRule)delegate;
            return ExcludingRecipesAndDelegatingTargetingRule.of(delegatingRule.delegate, (Collection)Util.make(new HashSet<ResourceLocation>(exclusions), it -> it.addAll(delegatingRule.exclusions)));
        }
        return new ExcludingRecipesAndDelegatingTargetingRule(delegate, exclusions);
    }

    public static ExcludingRecipesAndDelegatingTargetingRule of(ITargetingRule delegate, ResourceLocation ... exclusions) {
        return ExcludingRecipesAndDelegatingTargetingRule.of(delegate, new HashSet<ResourceLocation>(Arrays.asList(exclusions)));
    }

    public static ExcludingRecipesAndDelegatingTargetingRule of(ITargetingRule delegate, Recipe<?> ... exclusions) {
        return ExcludingRecipesAndDelegatingTargetingRule.of(delegate, Arrays.stream(exclusions).map(Recipe::getId).collect(Collectors.toSet()));
    }

    @Override
    public boolean shouldBeReplaced(Recipe<?> recipe, IRecipeManager<?> manager) {
        return !this.exclusions.contains(recipe.getId()) && this.delegate.shouldBeReplaced(recipe, manager);
    }

    @Override
    public String describe() {
        return String.format("%s, but excluding recipes {%s}", this.delegate.describe(), this.exclusions.stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
    }
}

