/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.rule;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.event.IGatherReplacementExclusionEvent;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public final class DefaultExclusionReplacements {
    private static final Supplier<Set<RecipeType<?>>> VANILLA_RECIPE_TYPES = Suppliers.memoize(() -> ImmutableSet.of((Object)RecipeType.CRAFTING, (Object)RecipeType.SMELTING, (Object)RecipeType.BLASTING, (Object)RecipeType.SMOKING, (Object)RecipeType.CAMPFIRE_COOKING, (Object)RecipeType.STONECUTTING, (Object[])new RecipeType[]{RecipeType.SMITHING}));

    public static void handleDefaultExclusions(IGatherReplacementExclusionEvent event) {
        IRecipeManager manager = event.getTargetedManager();
        if (VANILLA_RECIPE_TYPES.get().contains(manager.getRecipeType())) {
            manager.getAllRecipes().stream().filter(Recipe::isSpecial).forEach(event::addExclusion);
        }
        if (manager.getRecipeType() == CraftTweakerRegistries.RECIPE_TYPE_SCRIPTS) {
            manager.getAllRecipes().forEach(event::addExclusion);
        }
    }
}

