/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.recipe.replace.ReplacerAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.handler.ITargetingRule;
import com.blamejared.crafttweaker.api.recipe.manager.GenericRecipesManager;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.event.IGatherReplacementExclusionEvent;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.EverythingTargetingRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.ExcludingManagersAndDelegatingTargetingRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.ExcludingModsAndDelegatingTargetingRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.ExcludingRecipesAndDelegatingTargetingRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.FullIngredientReplacementRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.IngredientReplacementRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.OutputTargetingRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.RegexTargetingRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.SpecificManagersTargetingRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.SpecificModsTargetingRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.SpecificRecipesTargetingRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.StackTargetingReplacementRule;
import com.blamejared.crafttweaker.api.recipe.replacement.rule.ZenTargetingRule;
import com.blamejared.crafttweaker.api.util.NameUtil;
import com.blamejared.crafttweaker.api.zencode.util.PositionUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.recipe.Replacer")
@Document(value="vanilla/api/recipe/Replacer")
public final class Replacer {
    private static final Function<ResourceLocation, ResourceLocation> DEFAULT_REPLACER = id -> NameUtil.isAutogeneratedName(id) ? id : NameUtil.generateNameFrom(id.getNamespace() + "." + id.getPath());
    private static final Supplier<BiFunction<ResourceLocation, String, String>> DEFAULT_CUSTOM_FUNCTION = Suppliers.memoize(() -> (id, original) -> original);
    private static final Supplier<Map<IRecipeManager<?>, Collection<ResourceLocation>>> DEFAULT_EXCLUSIONS = Suppliers.memoize(() -> GenericRecipesManager.INSTANCE.getAllManagers().stream().map(Replacer::gatherDefaultExclusions).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
    private final ITargetingRule targetingRule;
    private final List<IReplacementRule> replacementRules;
    private final Map<ResourceLocation, String> userRenames;
    private final BiFunction<ResourceLocation, String, String> userRenamingFunction;
    private final boolean suppressWarnings;
    private final boolean isSimple;

    private Replacer(ITargetingRule rule) {
        this(rule, new ArrayList<IReplacementRule>(), new TreeMap<ResourceLocation, String>(), null, false);
    }

    private Replacer(ITargetingRule targetingRule, List<IReplacementRule> replacementRules, Map<ResourceLocation, String> userRenames, BiFunction<ResourceLocation, String, String> userRenamingFunction, boolean suppressWarnings) {
        this.targetingRule = targetingRule;
        this.replacementRules = new ArrayList<IReplacementRule>(replacementRules);
        this.userRenames = new TreeMap<ResourceLocation, String>(userRenames);
        this.userRenamingFunction = userRenamingFunction;
        this.suppressWarnings = suppressWarnings;
        this.isSimple = targetingRule instanceof SpecificRecipesTargetingRule;
    }

    @ZenCodeType.Method
    public static Replacer forRecipes(Recipe<?> ... recipes) {
        return new Replacer(SpecificRecipesTargetingRule.of(recipes));
    }

    @ZenCodeType.Method
    public static Replacer forMods(String ... mods) {
        return new Replacer(SpecificModsTargetingRule.of(mods));
    }

    @ZenCodeType.Method
    public static Replacer forTypes(IRecipeManager<?> ... managers) {
        return new Replacer(SpecificManagersTargetingRule.of(managers));
    }

    @Deprecated
    @ZenCodeType.Method
    public static Replacer forAllTypes() {
        return Replacer.forEverything();
    }

    @ZenCodeType.Method
    public static Replacer forEverything() {
        return new Replacer(EverythingTargetingRule.of());
    }

    @Deprecated
    @ZenCodeType.Method
    public static Replacer forAllTypesExcluding(IRecipeManager<?> ... managers) {
        return Replacer.forEverything().excluding(managers);
    }

    @ZenCodeType.Method
    public static Replacer forOutput(IIngredient output, IRecipeManager<?> ... whitelist) {
        return new Replacer(OutputTargetingRule.of(output, whitelist));
    }

    @ZenCodeType.Method
    public static Replacer forRegexTypes(String regex) {
        return new Replacer(RegexTargetingRule.of(regex, false));
    }

    @ZenCodeType.Method
    public static Replacer forRegexRecipes(String regex) {
        return new Replacer(RegexTargetingRule.of(regex, true));
    }

    @ZenCodeType.Method
    public static Replacer forCustomRecipeSet(BiPredicate<Recipe<?>, IRecipeManager<?>> function) {
        return new Replacer(ZenTargetingRule.of(function));
    }

    private static Pair<IRecipeManager<?>, Collection<ResourceLocation>> gatherDefaultExclusions(IRecipeManager<?> manager) {
        IGatherReplacementExclusionEvent event = Services.EVENT.fireGatherReplacementExclusionEvent(manager);
        return Pair.of(manager, event.getExcludedRecipes());
    }

    @ZenCodeType.Method
    public Replacer excluding(ResourceLocation ... recipes) {
        return new Replacer(ExcludingRecipesAndDelegatingTargetingRule.of(this.targetingRule, recipes), this.replacementRules, this.userRenames, this.userRenamingFunction, this.suppressWarnings);
    }

    @ZenCodeType.Method
    public Replacer excluding(IRecipeManager<?> ... managers) {
        return new Replacer(ExcludingManagersAndDelegatingTargetingRule.of(this.targetingRule, managers), this.replacementRules, this.userRenames, this.userRenamingFunction, this.suppressWarnings);
    }

    @ZenCodeType.Method
    public Replacer excludingMods(String ... modids) {
        return new Replacer(ExcludingModsAndDelegatingTargetingRule.of(this.targetingRule, modids), this.replacementRules, this.userRenames, this.userRenamingFunction, this.suppressWarnings);
    }

    @ZenCodeType.Method
    public Replacer replace(IIngredient from, IIngredient to) {
        if (from instanceof IItemStack) {
            return this.replace((IItemStack)from, to);
        }
        return this.addReplacementRule(IngredientReplacementRule.create(from, to));
    }

    @ZenCodeType.Method(value="replaceStack")
    public Replacer replace(IItemStack from, IIngredient to) {
        return this.addReplacementRule(StackTargetingReplacementRule.create(from, to));
    }

    @ZenCodeType.Method
    public Replacer replaceFully(IIngredient from, IIngredient to) {
        return this.addReplacementRule(FullIngredientReplacementRule.create(from, to));
    }

    @ZenCodeType.Method
    public Replacer explicitlyRename(ResourceLocation oldName, String newName) {
        String actualNewName = this.fix(newName, oldName);
        if (this.userRenames.containsKey(oldName) && !this.userRenames.get(oldName).equals(actualNewName)) {
            CraftTweakerAPI.LOGGER.error("The same old name '{}' has been specified twice for renaming with two different strings '{}' and '{}': only the former will apply", (Object)oldName, (Object)this.userRenames.get(oldName), (Object)newName);
            return this;
        }
        this.userRenames.put(oldName, actualNewName);
        return this;
    }

    @ZenCodeType.Method
    public Replacer useForRenaming(BiFunction<ResourceLocation, String, String> function) {
        if (this.userRenamingFunction != null) {
            CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
            CraftTweakerAPI.LOGGER.warn("{}A renaming function has already been specified for this replacer: the old one will be replaced", position == CodePosition.UNKNOWN ? "" : position + ": ");
        }
        return new Replacer(this.targetingRule, this.replacementRules, this.userRenames, function, this.suppressWarnings);
    }

    @ZenCodeType.Method
    public Replacer suppressWarnings() {
        return new Replacer(this.targetingRule, this.replacementRules, this.userRenames, this.userRenamingFunction, true);
    }

    @ZenCodeType.Method
    public void execute() {
        if (this.replacementRules.isEmpty()) {
            return;
        }
        CraftTweakerAPI.apply(new ReplacerAction(this.targetingRule, this.isSimple, Collections.unmodifiableList(this.replacementRules), DEFAULT_EXCLUSIONS.get().values().stream().flatMap(Collection::stream).collect(Collectors.toSet()), this.buildGeneratorFunction(), this.suppressWarnings));
    }

    public Replacer addReplacementRule(IReplacementRule rule) {
        if (rule == IReplacementRule.EMPTY) {
            return this;
        }
        this.replacementRules.add(rule);
        return this;
    }

    private String fix(String newName, ResourceLocation oldName) {
        CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
        return NameUtil.fixing(newName, (fixed, mistakes) -> CraftTweakerAPI.LOGGER.warn("{}Invalid recipe rename '{}' from '{}', mistakes:\n{}\nThe new rename '{}' will be used", position == CodePosition.UNKNOWN ? "" : position + ": ", (Object)newName, (Object)oldName, (Object)String.join((CharSequence)"\n", mistakes), fixed));
    }

    private Function<ResourceLocation, ResourceLocation> buildGeneratorFunction() {
        if (this.userRenames.isEmpty() && this.userRenamingFunction == null) {
            return DEFAULT_REPLACER;
        }
        BiFunction<ResourceLocation, String, String> customFunction = Optional.ofNullable(this.userRenamingFunction).orElseGet(DEFAULT_CUSTOM_FUNCTION);
        BiFunction<String, String, ResourceLocation> fixer = (custom, original) -> {
            ResourceLocation originalRl = CraftTweakerConstants.rl(original);
            if (custom.equals(original) || NameUtil.isAutogeneratedName(originalRl)) {
                return originalRl;
            }
            return NameUtil.fromFixedName(custom, (fixed, mistakes) -> CraftTweakerAPI.LOGGER.warn("Invalid recipe rename '{}' specified in custom renaming function, mistakes:\n{}\nThe new rename will be '{}'", custom, (Object)String.join((CharSequence)"\n", mistakes), fixed));
        };
        return id -> {
            String original = Optional.ofNullable(this.userRenames.get(id)).orElseGet(() -> DEFAULT_REPLACER.apply((ResourceLocation)id).getPath());
            return (ResourceLocation)fixer.apply((String)customFunction.apply((ResourceLocation)id, original), original);
        };
    }
}

