/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.manager.base;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveAll;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByModid;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByName;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByOutput;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByRegex;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.visitor.DataToJsonStringVisitor;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.RecipeList;
import com.blamejared.crafttweaker.api.util.NameUtil;
import com.blamejared.crafttweaker.api.zencode.util.PositionUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;
import org.openzen.zencode.shared.CodePosition;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.recipe.IRecipeManager")
@Document(value="vanilla/api/recipe/manager/IRecipeManager")
public interface IRecipeManager<T extends Recipe<?>>
extends CommandStringDisplayable,
Iterable<T> {
    public static final Gson JSON_RECIPE_GSON = new GsonBuilder().create();

    @ZenCodeType.Method
    default public void addJsonRecipe(String name, MapData mapData) {
        name = this.fixRecipeName(name);
        JsonObject recipeObject = (JsonObject)JSON_RECIPE_GSON.fromJson(mapData.accept(DataToJsonStringVisitor.INSTANCE), JsonObject.class);
        ResourceLocation recipeTypeKey = this.getBracketResourceLocation();
        if (recipeObject.has("type")) {
            ResourceLocation recipeSerializerKey;
            try {
                recipeSerializerKey = new ResourceLocation(recipeObject.get("type").getAsString());
            }
            catch (ClassCastException | IllegalStateException | ResourceLocationException ex) {
                throw new IllegalArgumentException("Expected 'type' field to be a valid resource location.", ex);
            }
            if (!Services.REGISTRY.recipeSerializers().containsKey(recipeSerializerKey)) {
                throw new IllegalArgumentException("Recipe Serializer '%s' does not exist.".formatted(recipeSerializerKey));
            }
        } else if (Services.REGISTRY.recipeSerializers().containsKey(recipeTypeKey)) {
            recipeObject.addProperty("type", recipeTypeKey.toString());
        } else {
            throw new IllegalArgumentException("Recipe Type '%s' does not have a Recipe Serializer of the same ID. Please specify a serializer manually using the 'type' field in the JSON object.\n".formatted(recipeTypeKey));
        }
        Recipe iRecipe = RecipeManager.fromJson((ResourceLocation)new ResourceLocation("crafttweaker", name), (JsonObject)recipeObject);
        RecipeType recipeType = iRecipe.getType();
        if (recipeType != this.getRecipeType()) {
            throw new IllegalArgumentException("Recipe Serializer \"%s\" resulted in Recipe Type \"%s\" but expected Recipe Type \"%s\"\n".formatted(Services.REGISTRY.getRegistryKey(iRecipe.getSerializer()), Services.REGISTRY.recipeTypes().getKey(recipeType), recipeTypeKey));
        }
        CraftTweakerAPI.apply(new ActionAddRecipe<Recipe>(this, iRecipe, ""));
    }

    @ZenCodeType.Method
    default public @ZenCodeType.Nullable T getRecipeByName(String name) {
        return this.getRecipeList().get(name);
    }

    @ZenCodeType.Method
    default public List<T> getRecipesByOutput(IIngredient output) {
        return this.getRecipeList().getRecipesByOutput(output);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allRecipes")
    default public List<T> getAllRecipes() {
        return this.getRecipeList().getAllRecipes();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="recipeMap")
    default public Map<ResourceLocation, T> getRecipeMap() {
        return this.getRecipeList().getRecipes();
    }

    @ZenCodeType.Method
    default public void remove(IIngredient output) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByOutput(this, output));
    }

    @ZenCodeType.Method
    default public void removeByInput(IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveRecipe<Recipe>(this, iRecipe -> iRecipe.getIngredients().stream().anyMatch(ingredient -> ingredient.test(input.getInternal()))));
    }

    @Deprecated(forRemoval=true)
    default public void removeByName(String name) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByName(this, new ResourceLocation(name)));
    }

    @ZenCodeType.Method
    default public void removeByName(String ... names) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByName(this, (ResourceLocation[])Arrays.stream(names).map(ResourceLocation::new).toArray(ResourceLocation[]::new)));
    }

    @ZenCodeType.Method
    default public void removeByModid(String modid, @ZenCodeType.Optional(value="(name as string) as bool => false") Predicate<String> exclude) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByModid(this, modid, exclude));
    }

    @ZenCodeType.Method
    default public void removeByRegex(String regex, @ZenCodeType.Optional(value="(name as string) as bool => false") Predicate<String> exclude) {
        CraftTweakerAPI.apply(new ActionRemoveRecipeByRegex(this, regex, exclude));
    }

    @ZenCodeType.Method
    default public void removeAll() {
        CraftTweakerAPI.apply(new ActionRemoveAll(this));
    }

    public RecipeType<T> getRecipeType();

    default public RecipeList<T> getRecipeList() {
        return new RecipeList<T>(this.getRecipeType(), this.getRecipes(), CraftTweakerAPI.getAccessibleElementsProvider().accessibleRecipeManager().crafttweaker$getByName());
    }

    default public Map<ResourceLocation, T> getRecipes() {
        return CraftTweakerAPI.getAccessibleElementsProvider().accessibleRecipeManager().crafttweaker$getRecipes().computeIfAbsent(this.getRecipeType(), key -> new HashMap());
    }

    default public ResourceLocation getBracketResourceLocation() {
        return Services.REGISTRY.getRegistryKey(this.getRecipeType());
    }

    @Override
    default public String getCommandString() {
        return "<recipetype:" + this.getBracketResourceLocation() + ">";
    }

    default public String fixRecipeName(String name) {
        CodePosition position = PositionUtil.getZCScriptPositionFromStackTrace();
        return NameUtil.fixing(name, (fixed, mistakes) -> CraftTweakerAPI.LOGGER.warn("{}Invalid recipe name '{}', mistakes:\n{}\nNew recipe name: {}", position == CodePosition.UNKNOWN ? "" : position + ": ", (Object)name, (Object)String.join((CharSequence)"\n", mistakes), fixed));
    }

    @Override
    default public Iterator<T> iterator() {
        return this.getAllRecipes().iterator();
    }
}

