/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveAllGenericRecipes;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByModId;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByName;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByOutput;
import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeByRegex;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.visitor.DataToJsonStringVisitor;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.manager.RecipeManagerWrapper;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.GenericRecipesManager")
@Document(value="vanilla/api/recipe/manager/GenericRecipesManager")
public enum GenericRecipesManager {
    INSTANCE;


    @ZenCodeType.Method
    public void addJsonRecipe(String name, MapData data) {
        JsonObject recipeObject = (JsonObject)IRecipeManager.JSON_RECIPE_GSON.fromJson(data.accept(DataToJsonStringVisitor.INSTANCE), JsonObject.class);
        if (!recipeObject.has("type")) {
            throw new IllegalArgumentException("Serializer type missing!");
        }
        if (recipeObject.get("type").getAsString().equals("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Cannot add a recipe to the CraftTweaker Scripts recipe type!");
        }
        ResourceLocation recipeName = CraftTweakerConstants.rl(name);
        Recipe result = RecipeManager.fromJson((ResourceLocation)recipeName, (JsonObject)recipeObject);
        RecipeManagerWrapper recipeManagerWrapper = new RecipeManagerWrapper(result.getType());
        CraftTweakerAPI.apply(new ActionAddRecipe<Recipe>(recipeManagerWrapper, result, null));
    }

    @ZenCodeType.Method
    public Recipe<?> getRecipeByName(String name) {
        Recipe<?> recipe = this.getRecipeMap().get(new ResourceLocation(name));
        if (recipe == null) {
            throw new IllegalArgumentException("No recipe found with name: \"" + name + "\"");
        }
        return recipe;
    }

    @ZenCodeType.Method
    public List<Recipe<?>> getRecipesByOutput(IIngredient output) {
        return this.getAllRecipes().stream().filter(iRecipe -> output.matches(Services.PLATFORM.createMCItemStack(iRecipe.getResultItem()))).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allRecipes")
    public List<Recipe<?>> getAllRecipes() {
        return this.getAllManagers().stream().map(IRecipeManager::getAllRecipes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="recipeMap")
    public Map<ResourceLocation, Recipe<?>> getRecipeMap() {
        return this.getAllManagers().stream().map(IRecipeManager::getRecipeMap).flatMap(recipeMap -> recipeMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Deprecated(forRemoval=true)
    @ZenCodeType.Method
    public void removeRecipe(IIngredient output) {
        this.remove(output);
    }

    @ZenCodeType.Method
    public void remove(IIngredient output) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByOutput(output));
    }

    @Deprecated(forRemoval=true)
    public void removeByName(String name) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByName(name));
    }

    @ZenCodeType.Method
    public void removeByName(String ... names) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByName((ResourceLocation[])Arrays.stream(names).map(ResourceLocation::new).toArray(ResourceLocation[]::new)));
    }

    @ZenCodeType.Method
    public void removeByModid(String modId) {
        this.removeByModid(modId, null);
    }

    @ZenCodeType.Method
    public void removeByModid(String modId, Predicate<String> exclude) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByModId(modId, exclude));
    }

    @ZenCodeType.Method
    public void removeByRegex(String regex) {
        CraftTweakerAPI.apply(new ActionRemoveGenericRecipeByRegex(regex));
    }

    @ZenCodeType.Method
    public void removeAll() {
        CraftTweakerAPI.apply(new ActionRemoveAllGenericRecipes());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allManagers")
    public List<IRecipeManager<?>> getAllManagers() {
        return new ArrayList(RecipeTypeBracketHandler.getManagerInstances());
    }
}

