/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.handler;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.world.item.crafting.Recipe;

public interface IReplacementRule {
    public static final IReplacementRule EMPTY = new IReplacementRule(){

        @Override
        public <T, U extends Recipe<?>> Optional<T> getReplacement(T ingredient, Class<T> type, U recipe) {
            return Optional.empty();
        }

        @Override
        public String describe() {
            return "NO-OP";
        }
    };

    @SafeVarargs
    public static <T> Optional<T> chain(Optional<T> ... optionals) {
        return Arrays.stream(optionals).filter(Optional::isPresent).findFirst().orElseGet(Optional::empty);
    }

    public static <T, U, S extends Recipe<?>> Optional<T> withType(T ingredient, Class<T> type, S recipe, Class<U> targetedType, BiFunction<U, S, Optional<U>> producer) {
        return targetedType == type ? producer.apply((S)targetedType.cast(ingredient), recipe).map(type::cast) : Optional.empty();
    }

    public <T, U extends Recipe<?>> Optional<T> getReplacement(T var1, Class<T> var2, U var3);

    public String describe();
}

