/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.misc;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.misc.ActionSetCauldronInteraction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.misc.CTCauldronInteraction;
import com.blamejared.crafttweaker.mixin.common.access.block.AccessAbstractCauldronBlock;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Map;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.misc.Cauldron")
@Document(value="vanilla/api/misc/Cauldron")
public final class CTCauldron {
    @ZenCodeGlobals.Global(value="cauldron")
    public static final CTCauldron INSTANCE = new CTCauldron();

    private CTCauldron() {
    }

    @ZenCodeType.Method
    public void addEmptyInteraction(Item item, CTCauldronInteraction interaction) {
        this.addInteraction(CauldronInteraction.EMPTY, item, interaction);
    }

    @ZenCodeType.Method
    public void removeEmptyInteraction(Item item) {
        this.removeInteraction(CauldronInteraction.EMPTY, item);
    }

    @ZenCodeType.Method
    public void addWaterInteraction(Item item, CTCauldronInteraction interaction) {
        this.addInteraction(CauldronInteraction.WATER, item, interaction);
    }

    @ZenCodeType.Method
    public void removeWaterInteraction(Item item) {
        this.removeInteraction(CauldronInteraction.WATER, item);
    }

    @ZenCodeType.Method
    public void addLavaInteraction(Item item, CTCauldronInteraction interaction) {
        this.addInteraction(CauldronInteraction.LAVA, item, interaction);
    }

    @ZenCodeType.Method
    public void removeLavaInteraction(Item item) {
        this.removeInteraction(CauldronInteraction.LAVA, item);
    }

    @ZenCodeType.Method
    public void addPowderSnowInteraction(Item item, CTCauldronInteraction interaction) {
        this.addInteraction(CauldronInteraction.POWDER_SNOW, item, interaction);
    }

    @ZenCodeType.Method
    public void removePowderSnowInteraction(Item item) {
        this.removeInteraction(CauldronInteraction.POWDER_SNOW, item);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fillWaterInteraction")
    public CTCauldronInteraction getFillWaterInteraction() {
        return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((CauldronInteraction)CauldronInteraction.FILL_WATER).interact(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fillLavaInteraction")
    public CTCauldronInteraction getFillLavaInteraction() {
        return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((CauldronInteraction)CauldronInteraction.FILL_LAVA).interact(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fillPowderSnowInteraction")
    public CTCauldronInteraction getFillPowderSnowInteraction() {
        return (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ((CauldronInteraction)CauldronInteraction.FILL_POWDER_SNOW).interact(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
    }

    @ZenCodeType.Method
    public void addInteraction(Block cauldronBlock, Item item, CTCauldronInteraction interaction) {
        if (!(cauldronBlock instanceof AbstractCauldronBlock)) {
            throw new IllegalStateException("Provided block: '" + cauldronBlock + "' is not an AbstractCauldronBlock!");
        }
        AbstractCauldronBlock cauldron = (AbstractCauldronBlock)cauldronBlock;
        this.addInteraction(((AccessAbstractCauldronBlock)cauldron).crafttweaker$getInteractions(), item, interaction);
    }

    @ZenCodeType.Method
    public void removeInteraction(Block cauldronBlock, Item item) {
        if (!(cauldronBlock instanceof AbstractCauldronBlock)) {
            throw new IllegalStateException("Provided block: '" + cauldronBlock + "' is not an AbstractCauldronBlock!");
        }
        AbstractCauldronBlock cauldron = (AbstractCauldronBlock)cauldronBlock;
        this.removeInteraction(((AccessAbstractCauldronBlock)cauldron).crafttweaker$getInteractions(), item);
    }

    public void addInteraction(Map<Item, CauldronInteraction> map, Item item, CTCauldronInteraction interaction) {
        CraftTweakerAPI.apply(new ActionSetCauldronInteraction(map, item, interaction::interact));
    }

    public void removeInteraction(Map<Item, CauldronInteraction> map, Item item) {
        CraftTweakerAPI.apply(new ActionSetCauldronInteraction(map, item, null));
    }
}

