/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.logger.appender;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.mojang.datafixers.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="PlayerAppender", category="Core", elementType="appender")
public class PlayerAppender
extends AbstractAppender {
    private static final Map<Level, Pair<Style, Style>> STYLING = (Map)Util.make(new HashMap(), (T map) -> {
        map.put(Level.FATAL, PlayerAppender.make(ChatFormatting.DARK_RED.getColor(), ChatFormatting.RED.getColor()));
        map.put(Level.ERROR, PlayerAppender.make(ChatFormatting.DARK_RED.getColor(), ChatFormatting.RED.getColor()));
        map.put(Level.WARN, PlayerAppender.make(ChatFormatting.GOLD.getColor(), ChatFormatting.YELLOW.getColor()));
        map.put(Level.INFO, PlayerAppender.make(ChatFormatting.DARK_GREEN.getColor(), ChatFormatting.GREEN.getColor()));
        map.put(Level.DEBUG, PlayerAppender.make(ChatFormatting.DARK_PURPLE.getColor(), ChatFormatting.LIGHT_PURPLE.getColor()));
        map.put(Level.TRACE, PlayerAppender.make(ChatFormatting.DARK_GRAY.getColor(), ChatFormatting.GRAY.getColor()));
        map.put(Level.ALL, PlayerAppender.make(ChatFormatting.DARK_GREEN.getColor(), ChatFormatting.GREEN.getColor()));
        map.put(Level.OFF, PlayerAppender.make(ChatFormatting.BLACK.getColor(), ChatFormatting.GREEN.getColor()));
    });
    private final List<Player> players = new ArrayList<Player>();
    private final List<LogMessage> previousMessages = new ArrayList<LogMessage>();

    private static Pair<Style, Style> make(Integer header, Integer content) {
        return Pair.of((Object)(header == null ? Style.EMPTY : Style.EMPTY.withColor(TextColor.fromRgb((int)header))), (Object)(content == null ? Style.EMPTY : Style.EMPTY.withColor(TextColor.fromRgb((int)content))));
    }

    public PlayerAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout);
    }

    @PluginFactory
    public static PlayerAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter, @Nullable @PluginElement(value="Layout") Layout<? extends Serializable> layout) {
        return new PlayerAppender(name, filter, layout);
    }

    public void sendMessage(Player player, LogMessage event) {
        Pair<Style, Style> styling = STYLING.get(event.level());
        MutableComponent header = new TextComponent("[%s]: ".formatted(event.level().name())).setStyle((Style)styling.getFirst());
        MutableComponent line = header.append((Component)new TextComponent(event.message()).setStyle((Style)styling.getSecond()));
        player.sendMessage((Component)line, CraftTweakerConstants.CRAFTTWEAKER_UUID);
    }

    public void append(LogEvent event) {
        String message = ((PatternLayout)this.getLayout()).toSerializable(event).replaceAll("\r\n", " ");
        LogMessage logMessage = new LogMessage(message, event.getLevel());
        this.players.forEach(player -> this.sendMessage((Player)player, logMessage));
        this.previousMessages.add(logMessage);
    }

    public void addPlayerLogger(Player player) {
        this.players.add(player);
        this.previousMessages.forEach(event -> this.sendMessage(player, (LogMessage)event));
    }

    public void removePlayerLogger(Player player) {
        this.players.remove(player);
    }

    public void clearPreviousMessages() {
        this.previousMessages.clear();
    }

    private record LogMessage(String message, Level level) {
    }
}

