/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.item.ActionSetFood;
import com.blamejared.crafttweaker.api.action.item.ActionSetItemProperty;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.IData;
import com.blamejared.crafttweaker.api.data.base.converter.JSONConverter;
import com.blamejared.crafttweaker.api.data.base.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.util.AttributeUtil;
import com.blamejared.crafttweaker.api.util.EnchantmentUtil;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessItem;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IItemStack")
@Document(value="vanilla/api/item/IItemStack")
public interface IItemStack
extends IIngredient,
IIngredientWithAmount {
    @ZenCodeType.Field
    public static final String CRAFTTWEAKER_DATA_KEY = "CraftTweakerData";
    @ZenCodeType.Field
    public static final UUID BASE_ATTACK_DAMAGE_UUID = AccessItem.crafttweaker$getBASE_ATTACK_DAMAGE_UUID();
    @ZenCodeType.Field
    public static final UUID BASE_ATTACK_SPEED_UUID = AccessItem.crafttweaker$getBASE_ATTACK_SPEED_UUID();

    @ZenCodeType.Method
    public IItemStack copy();

    @ZenCodeType.Getter(value="registryName")
    default public ResourceLocation getRegistryName() {
        return Services.REGISTRY.getRegistryKey(this.getInternal().getItem());
    }

    @ZenCodeType.Getter(value="owner")
    default public String getOwner() {
        return this.getRegistryName().getNamespace();
    }

    @Override
    default public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="maxStackSize")
    default public int getMaxStackSize() {
        return this.getInternal().getItem().getMaxStackSize();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="maxStackSize")
    default public void setMaxStackSize(int newMaxStackSize) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Integer>(this, "Max Stack Size", newMaxStackSize, this.getInternal().getItem().getMaxStackSize(), ((AccessItem)this.getInternal().getItem())::crafttweaker$setMaxStackSize));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="rarity")
    default public Rarity getRarity() {
        return this.getInternal().getRarity();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="rarity")
    default public void setRarity(Rarity newRarity) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Rarity>(this, "Rarity", newRarity, this.getInternal().getRarity(), ((AccessItem)this.getInternal().getItem())::crafttweaker$setRarity));
    }

    @ZenCodeType.Method
    default public IItemStack withLore(Component ... lore) {
        return this.modify(itemStack -> {
            CompoundTag tag = itemStack.getOrCreateTagElement("display");
            if (lore != null || lore.length == 0) {
                ListTag listtag = new ListTag();
                for (Component component : lore) {
                    listtag.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)component)));
                }
                tag.put("Lore", (Tag)listtag);
            } else {
                tag.remove("Lore");
            }
        });
    }

    @ZenCodeType.Getter(value="displayName")
    default public Component getDisplayName() {
        return this.getInternal().getDisplayName();
    }

    @ZenCodeType.Method
    default public IItemStack withDisplayName(Component name) {
        return this.modify(itemStack -> itemStack.setHoverName(name));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="hoverName")
    default public Component getHoverName() {
        return this.getInternal().getHoverName();
    }

    @ZenCodeType.Method
    default public void resetHoverName() {
        this.getInternal().resetHoverName();
    }

    @ZenCodeType.Getter(value="hasCustomHoverName")
    default public boolean hasDisplayName() {
        return this.getInternal().hasCustomHoverName();
    }

    @ZenCodeType.Getter(value="hasFoil")
    default public boolean hasFoil() {
        return this.getInternal().hasFoil();
    }

    @ZenCodeType.Getter(value="isEnchantable")
    default public boolean isEnchantable() {
        return this.getInternal().isEnchantable();
    }

    @ZenCodeType.Getter(value="isEnchanted")
    default public boolean isEnchanted() {
        return this.getInternal().isEnchanted();
    }

    @ZenCodeType.Getter(value="baseRepairCost")
    default public int getBaseRepairCost() {
        return this.getInternal().getBaseRepairCost();
    }

    @Override
    @ZenCodeType.Getter(value="amount")
    default public int getAmount() {
        return this.getInternal().getCount();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public IItemStack setAmount(int amount) {
        return this.modify(itemStack -> itemStack.setCount(amount));
    }

    @ZenCodeType.Method
    default public IItemStack grow(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.setAmount(this.getAmount() + amount);
    }

    @ZenCodeType.Method
    default public IItemStack shrink(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.setAmount(this.getAmount() - amount);
    }

    @ZenCodeType.Getter(value="stackable")
    default public boolean isStackable() {
        return this.getInternal().isStackable();
    }

    @ZenCodeType.Method
    default public IItemStack withDamage(int damage) {
        return this.modify(itemStack -> itemStack.setDamageValue(damage));
    }

    @ZenCodeType.Method
    default public IItemStack withAttributeModifier(Attribute attribute, String uuid, String name, double value, AttributeModifier.Operation operation, EquipmentSlot[] slotTypes, @ZenCodeType.OptionalBoolean boolean preserveDefaults) {
        return this.withAttributeModifier(attribute, UUID.fromString(uuid), name, value, operation, slotTypes, preserveDefaults);
    }

    @ZenCodeType.Method
    default public IItemStack withAttributeModifier(Attribute attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation, EquipmentSlot[] slotTypes, @ZenCodeType.OptionalBoolean boolean preserveDefaults) {
        return this.modify(itemStack -> {
            for (EquipmentSlot slotType : slotTypes) {
                if (preserveDefaults) {
                    AttributeUtil.addAttributeModifier(itemStack, attribute, new AttributeModifier(uuid, name, value, operation), slotType);
                    continue;
                }
                itemStack.addAttributeModifier(attribute, new AttributeModifier(uuid, name, value, operation), slotType);
            }
        });
    }

    @ZenCodeType.Method
    default public IItemStack withAttributeModifier(Attribute attribute, String name, double value, AttributeModifier.Operation operation, EquipmentSlot[] slotTypes, @ZenCodeType.OptionalBoolean boolean preserveDefaults) {
        return this.modify(itemStack -> {
            for (EquipmentSlot slotType : slotTypes) {
                if (preserveDefaults) {
                    AttributeUtil.addAttributeModifier(itemStack, attribute, new AttributeModifier(name, value, operation), slotType);
                    continue;
                }
                itemStack.addAttributeModifier(attribute, new AttributeModifier(name, value, operation), slotType);
            }
        });
    }

    @ZenCodeType.Method
    default public Map<Attribute, List<AttributeModifier>> getAttributes(EquipmentSlot slotType) {
        return this.getInternal().getAttributeModifiers(slotType).asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, attributeAttributeModifierEntry -> new ArrayList((Collection)attributeAttributeModifierEntry.getValue())));
    }

    @ZenCodeType.Getter(value="damageableItem")
    default public boolean isDamageableItem() {
        return this.getInternal().isDamageableItem();
    }

    @ZenCodeType.Getter(value="damaged")
    default public boolean isDamaged() {
        return this.getInternal().isDamaged();
    }

    @ZenCodeType.Getter(value="maxDamage")
    default public int getMaxDamage() {
        return this.getInternal().getMaxDamage();
    }

    @ZenCodeType.Setter(value="maxDamage")
    default public void setMaxDamage(int newMaxDamage) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Integer>(this, "Max Damage", newMaxDamage, this.getInternal().getMaxDamage(), ((AccessItem)this.getInternal().getItem())::crafttweaker$setMaxDamage));
    }

    @ZenCodeType.Getter(value="descriptionId")
    default public String getDescriptionId() {
        return this.getInternal().getDescriptionId();
    }

    @ZenCodeType.Method
    default public IItemStack withTag(MapData tag) {
        return this.modify(itemStack -> itemStack.setTag(tag.getInternal()));
    }

    @ZenCodeType.Method
    default public IItemStack withoutTag() {
        return this.modify(itemStack -> itemStack.setTag(null));
    }

    @ZenCodeType.Getter(value="hasTag")
    default public boolean hasTag() {
        return this.getInternal().hasTag();
    }

    @ZenCodeType.Getter(value="tag")
    default public @ZenCodeType.Nullable MapData getTag() {
        return TagToDataConverter.convertCompound(this.getInternal().getTag());
    }

    @ZenCodeType.Method
    default public MapData getOrCreateTag() {
        if (this.getInternal().getTag() == null) {
            this.getInternal().setTag(new CompoundTag());
        }
        return this.getTag();
    }

    @Override
    default public boolean matches(IItemStack stack, boolean ignoreDamage) {
        ItemStack stack1 = this.getInternal();
        ItemStack stack2 = stack.getInternal();
        if (stack1.isEmpty() != stack2.isEmpty()) {
            return false;
        }
        if (stack1.getItem() != stack2.getItem()) {
            return false;
        }
        if (stack1.getCount() > stack2.getCount()) {
            return false;
        }
        if (!ignoreDamage && stack1.getDamageValue() != stack2.getDamageValue()) {
            return false;
        }
        CompoundTag stack1Tag = stack1.getTag();
        CompoundTag stack2Tag = stack2.getTag();
        if (stack1Tag == null && stack2Tag == null) {
            return true;
        }
        MapData stack2Data = TagToDataConverter.convertCompound(stack2Tag);
        MapData stack1Data = TagToDataConverter.convertCompound(stack1Tag);
        if (stack1Data == null) {
            return true;
        }
        if (ignoreDamage) {
            stack1Data = stack1Data.copyInternal();
            stack1Data.remove("Damage");
            if (stack2Data != null) {
                stack2Data = stack2Data.copyInternal();
                stack2Data.remove("Damage");
            }
        }
        return stack2Data != null && stack2Data.contains(stack1Data);
    }

    @ZenCodeType.Getter(value="useDuration")
    default public int getUseDuration() {
        return this.getInternal().getUseDuration();
    }

    @ZenCodeType.Getter(value="useOnRelease")
    default public boolean useOnRelease() {
        return this.getInternal().useOnRelease();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="food")
    default public @ZenCodeType.Nullable FoodProperties getFood() {
        return this.getInternal().getItem().getFoodProperties();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="food")
    default public void setFood(@ZenCodeType.Nullable FoodProperties food) {
        CraftTweakerAPI.apply(new ActionSetFood(this, food, this.getInternal().getItem().getFoodProperties()));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isEdible")
    default public boolean isEdible() {
        return this.getInternal().isEdible();
    }

    @ZenCodeType.Getter(value="burnTime")
    default public int getBurnTime() {
        return Services.EVENT.getBurnTime(this);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fireResistant")
    default public boolean isFireResistant() {
        return this.getInternal().getItem().isFireResistant();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="fireResistant")
    default public void setFireResistant(boolean fireResistant) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Boolean>(this, "Fire Resistant", fireResistant, this.getInternal().getItem().isFireResistant(), ((AccessItem)this.getInternal().getItem())::crafttweaker$setFireResistant));
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MOD)
    default public Percentaged<IItemStack> percent(double percentage) {
        return new Percentaged<IItemStack>(this, percentage / 100.0, iItemStack -> iItemStack.getCommandString() + " % " + percentage);
    }

    @ZenCodeType.Caster(implicit=true)
    default public Percentaged<IItemStack> asWeightedItemStack() {
        return this.percent(100.0);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="definition")
    @ZenCodeType.Caster(implicit=true)
    default public Item getDefinition() {
        return this.getInternal().getItem();
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public ItemLike asItemLike() {
        return this.getInternal().getItem();
    }

    @ZenCodeType.Method
    public IItemStack asMutable();

    @ZenCodeType.Method
    public IItemStack asImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isMutable")
    default public boolean isMutable() {
        return !this.isImmutable();
    }

    @ZenCodeType.Getter(value="damage")
    default public int getDamage() {
        return this.getInternal().getDamageValue();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="enchantments")
    default public Map<Enchantment, Integer> getEnchantments() {
        return EnchantmentHelper.getEnchantments((ItemStack)this.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="enchantments")
    default public IItemStack setEnchantments(Map<Enchantment, Integer> enchantments) {
        return this.modify(newStack -> EnchantmentUtil.setEnchantments(enchantments, newStack));
    }

    @ZenCodeType.Method
    default public int getEnchantmentLevel(Enchantment enchantment) {
        return this.getEnchantments().getOrDefault(enchantment, 0);
    }

    @ZenCodeType.Method
    default public IItemStack withEnchantment(Enchantment enchantment, @ZenCodeType.OptionalInt(value=1) int level) {
        return this.modify(itemStack -> {
            Map<Enchantment, Integer> enchantments = this.getEnchantments();
            enchantments.put(enchantment, level);
            EnchantmentUtil.setEnchantments(enchantments, itemStack);
        });
    }

    @ZenCodeType.Method
    default public IItemStack removeEnchantment(Enchantment enchantment) {
        return this.modify(itemStack -> {
            Map<Enchantment, Integer> enchantments = this.getEnchantments();
            enchantments.remove(enchantment);
            EnchantmentUtil.setEnchantments(enchantments, itemStack);
        });
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public ItemStack getInternal();

    @Override
    default public Ingredient asVanillaIngredient() {
        if (this.getInternal().isEmpty()) {
            return Ingredient.EMPTY;
        }
        if (!this.getInternal().hasTag()) {
            return Ingredient.of((ItemStack[])new ItemStack[]{this.getImmutableInternal()});
        }
        return Services.REGISTRY.getIngredientPartialTag(this.getImmutableInternal());
    }

    @Override
    default public IData asIData() {
        MapData data = (MapData)JSONConverter.convert(this.asVanillaIngredient().toJson());
        data.put("count", new IntData(this.getAmount()));
        return data;
    }

    @ZenCodeType.Method
    default public ItemStack getImmutableInternal() {
        return this.getInternal().copy();
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IIngredientWithAmount asIIngredientWithAmount() {
        return this;
    }

    @Override
    default public IItemStack getIngredient() {
        return this;
    }

    public IItemStack modify(Consumer<ItemStack> var1);
}

