/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.transform.serializer;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.transform.type.TransformReplace;
import com.blamejared.crafttweaker.platform.Services;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public enum TransformReplaceSerializer implements IIngredientTransformerSerializer<TransformReplace<?>>
{
    INSTANCE;


    @Override
    public TransformReplace<?> fromNetwork(FriendlyByteBuf buffer) {
        ItemStack replaceWith = buffer.readItem();
        return new TransformReplace(Services.PLATFORM.createMCItemStack(replaceWith));
    }

    @Override
    public TransformReplace<?> fromJson(JsonObject json) {
        Ingredient.Value iItemList = Ingredient.valueFromJson((JsonObject)json.getAsJsonObject("replaceWith"));
        ItemStack replaceWith = (ItemStack)iItemList.getItems().iterator().next();
        return new TransformReplace(Services.PLATFORM.createMCItemStack(replaceWith));
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer, TransformReplace<?> ingredient) {
        buffer.writeItem(ingredient.getReplaceWith().getInternal());
    }

    @Override
    public JsonObject toJson(TransformReplace<?> transformer) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", this.getType().toString());
        jsonObject.add("replaceWith", transformer.getReplaceWith().asVanillaIngredient().toJson());
        return jsonObject;
    }

    @Override
    public ResourceLocation getType() {
        return CraftTweakerConstants.rl("transform_replace");
    }
}

