/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.game;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.locale.Language;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.game.Game")
@Document(value="vanilla/api/game/Game")
public class Game {
    @ZenCodeGlobals.Global(value="game")
    public static final Game INSTANCE = new Game();

    private Game() {
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="effects")
    public Collection<MobEffect> getMobEffects() {
        return Services.REGISTRY.mobEffects().stream().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="enchantments")
    public Collection<Enchantment> getEnchantments() {
        return Services.REGISTRY.enchantments().stream().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="entityTypes")
    public Collection<EntityType> getEntityTypes() {
        return Services.REGISTRY.entityTypes().stream().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fluids")
    public Collection<Fluid> getFluids() {
        return Services.REGISTRY.fluids().stream().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="items")
    public Collection<IItemStack> getItemStacks() {
        return Services.REGISTRY.items().stream().map(Item::getDefaultInstance).filter(stack -> !stack.isEmpty()).map(Services.PLATFORM::createMCItemStack).toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="potions")
    public Collection<Potion> getPotions() {
        return Services.REGISTRY.potions().stream().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="recipeTypes")
    public Collection<IRecipeManager> getRecipeTypes() {
        return Services.REGISTRY.recipeTypes().stream().map(RecipeTypeBracketHandler::getOrDefault).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blocks")
    public Collection<Block> getBlocks() {
        return Services.REGISTRY.blocks().stream().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blockStates")
    public Collection<BlockState> getBlockStates() {
        return Services.REGISTRY.blocks().stream().flatMap(block -> block.getStateDefinition().getPossibleStates().stream()).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="villagerProfessions")
    public Collection<VillagerProfession> getProfessions() {
        return Services.REGISTRY.villagerProfessions().stream().toList();
    }

    @ZenCodeType.Method
    public String localize(String translationKey) {
        return Language.getInstance().getOrDefault(translationKey);
    }
}

