/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.BoolData;
import com.blamejared.crafttweaker.api.data.StringData;
import com.blamejared.crafttweaker.api.data.base.IData;
import com.blamejared.crafttweaker.api.data.base.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.data.base.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.MapData")
@ZenRegister
@Document(value="vanilla/api/data/MapData")
public class MapData
implements IData {
    private final CompoundTag internal;
    private final Set<String> boolDataKeys;

    public MapData(CompoundTag internal) {
        this(internal, new HashSet<String>());
    }

    @ZenCodeType.Constructor
    public MapData() {
        this(new CompoundTag());
    }

    @ZenCodeType.Constructor
    public MapData(Map<String, IData> map) {
        this();
        this.putAll(map);
    }

    public MapData(CompoundTag internal, Set<String> boolDataKeys) {
        this.internal = internal;
        this.boolDataKeys = boolDataKeys;
    }

    @ZenCodeType.Method
    public void putAll(Map<String, IData> map) {
        map.forEach((s, iData) -> {
            this.getInternal().put(s, iData.getInternal());
            if (iData instanceof BoolData) {
                this.boolDataKeys.add((String)s);
            }
        });
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.ADD)
    public MapData opAdd(IData data) {
        this.putAll(data.asMap());
        return this;
    }

    @ZenCodeType.Getter(value="keySet")
    public Set<String> getKeySet() {
        return this.getInternal().getAllKeys();
    }

    @ZenCodeType.Getter(value="size")
    public int getSize() {
        return this.getInternal().size();
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MEMBERSETTER)
    public @ZenCodeType.Nullable IData put(String key, IData value) {
        if (value instanceof BoolData) {
            this.boolDataKeys.add(key);
        }
        return TagToDataConverter.convert(this.getInternal().put(key, value.getInternal()));
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MEMBERGETTER)
    public @ZenCodeType.Nullable IData getAt(String key) {
        if (this.boolDataKeys.contains(key)) {
            return new BoolData(this.getInternal().getByte(key) == 1);
        }
        return TagToDataConverter.convert(this.getInternal().get(key));
    }

    @ZenCodeType.Method
    public <T extends IData> @ZenCodeType.Nullable T getData(Class<T> clazz, String key) {
        if ((clazz == null || clazz.equals(BoolData.class)) && this.boolDataKeys.contains(key)) {
            return (T)new BoolData(this.getInternal().getByte(key) == 1);
        }
        try {
            return TagToDataConverter.convertTo(this.getInternal().get(key), clazz);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to convert IData to " + clazz, e);
        }
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    public boolean contains(String key) {
        return this.getInternal().contains(key);
    }

    @ZenCodeType.Method
    public void remove(String key) {
        this.boolDataKeys.remove(key);
        this.getInternal().remove(key);
    }

    @ZenCodeType.Getter(value="isEmpty")
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @ZenCodeType.Method
    public MapData merge(MapData other) {
        HashSet<String> newBoolDataKeys = new HashSet<String>(this.boolDataKeys);
        newBoolDataKeys.addAll(other.boolDataKeys);
        return new MapData(this.getInternal().merge(other.getInternal()), newBoolDataKeys);
    }

    @Override
    public MapData copy() {
        return new MapData(this.getInternal(), new HashSet<String>(this.boolDataKeys));
    }

    @Override
    public MapData copyInternal() {
        return new MapData(this.getInternal().copy(), new HashSet<String>(this.boolDataKeys));
    }

    public CompoundTag getInternal() {
        return this.internal;
    }

    @Override
    public Map<String, IData> asMap() {
        HashMap<String, IData> newMap = new HashMap<String, IData>();
        this.getInternal().getAllKeys().forEach(s -> newMap.put((String)s, this.getAt((String)s)));
        return newMap;
    }

    @Override
    public boolean contains(IData data) {
        if (data instanceof StringData) {
            return this.getInternal().contains(data.asString());
        }
        Map<String, IData> dataMap = data.asMap();
        if (dataMap == null) {
            return false;
        }
        for (Map.Entry<String, IData> dataEntry : dataMap.entrySet()) {
            if (!this.getInternal().contains(dataEntry.getKey())) {
                return false;
            }
            if (TagToDataConverter.convert(this.getInternal().get(dataEntry.getKey())).contains(dataEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    @ZenCodeType.Caster(implicit=true)
    public Map<String, IData> castToMap() {
        return this.asMap();
    }

    @Override
    public IData.Type getType() {
        return IData.Type.MAP;
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitMap(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapData mapData = (MapData)o;
        return this.internal.equals((Object)mapData.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }

    public Set<String> boolDataKeys() {
        return this.boolDataKeys;
    }
}

