/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.base.ICollectionData;
import com.blamejared.crafttweaker.api.data.base.IData;
import com.blamejared.crafttweaker.api.data.base.INumberData;
import com.blamejared.crafttweaker.api.data.base.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.IntArrayData")
@ZenRegister
@Document(value="vanilla/api/data/IntArrayData")
public class IntArrayData
implements ICollectionData {
    private final IntArrayTag internal;

    public IntArrayData(IntArrayTag internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public IntArrayData(int[] internal) {
        this.internal = new IntArrayTag(internal);
    }

    @Override
    public IntArrayData copy() {
        return new IntArrayData(this.getInternal());
    }

    @Override
    public IntArrayData copyInternal() {
        return new IntArrayData(this.getInternal().copy());
    }

    public IntArrayTag getInternal() {
        return this.internal;
    }

    @Override
    public IntData setAt(int index, IData value) {
        if (value instanceof NumericTag) {
            return new IntData(this.getInternal().set(index, IntTag.valueOf((int)((INumberData)value).getInt())));
        }
        return null;
    }

    @Override
    public void add(int index, IData value) {
        if (value instanceof INumberData) {
            this.getInternal().add(index, IntTag.valueOf((int)((INumberData)value).getInt()));
        }
    }

    @Override
    public void add(IData value) {
        if (value instanceof INumberData) {
            this.getInternal().add((Object)IntTag.valueOf((int)((INumberData)value).getInt()));
        }
    }

    @Override
    public IntData remove(int index) {
        return new IntData(this.getInternal().remove(index));
    }

    @Override
    public IData getAt(int index) {
        return new IntData(this.getInternal().get(index));
    }

    @Override
    public int size() {
        return this.getInternal().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public void clear() {
        this.getInternal().clear();
    }

    @Override
    public List<IData> asList() {
        int[] intArray = this.getInternal().getAsIntArray();
        ArrayList<IData> list = new ArrayList<IData>(intArray.length);
        for (int i : intArray) {
            list.add(new IntData(i));
        }
        return list;
    }

    @Override
    public IData.Type getType() {
        return IData.Type.INT_ARRAY;
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitIntArray(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArrayData that = (IntArrayData)o;
        return this.internal.equals((Object)that.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }
}

