/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.ByteData;
import com.blamejared.crafttweaker.api.data.base.ICollectionData;
import com.blamejared.crafttweaker.api.data.base.IData;
import com.blamejared.crafttweaker.api.data.base.INumberData;
import com.blamejared.crafttweaker.api.data.base.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.NumericTag;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.ByteArrayData")
@ZenRegister
@Document(value="vanilla/api/data/ByteArrayData")
public class ByteArrayData
implements ICollectionData {
    private final ByteArrayTag internal;

    public ByteArrayData(ByteArrayTag internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public ByteArrayData(byte[] internal) {
        this.internal = new ByteArrayTag(internal);
    }

    @Override
    public ByteArrayData copy() {
        return new ByteArrayData(this.getInternal());
    }

    @Override
    public ByteArrayData copyInternal() {
        return new ByteArrayData((ByteArrayTag)this.getInternal().copy());
    }

    public ByteArrayTag getInternal() {
        return this.internal;
    }

    @Override
    public IData setAt(int index, IData value) {
        if (value instanceof NumericTag) {
            return new ByteData(this.getInternal().set(index, ByteTag.valueOf((byte)((INumberData)value).getByte())));
        }
        return null;
    }

    @Override
    public void add(int index, IData value) {
        if (value instanceof INumberData) {
            this.getInternal().add(index, ByteTag.valueOf((byte)((INumberData)value).getByte()));
        }
    }

    @Override
    public void add(IData value) {
        if (value instanceof INumberData) {
            this.getInternal().add((Object)ByteTag.valueOf((byte)((INumberData)value).getByte()));
        }
    }

    @Override
    public IData remove(int index) {
        return new ByteData(this.getInternal().remove(index));
    }

    @Override
    public IData getAt(int index) {
        return new ByteData(this.getInternal().get(index));
    }

    @Override
    public int size() {
        return this.getInternal().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public void clear() {
        this.getInternal().clear();
    }

    @Override
    public IData.Type getType() {
        return IData.Type.BYTE_ARRAY;
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitByteArray(this);
    }

    @Override
    public List<IData> asList() {
        byte[] byteArray = this.getInternal().getAsByteArray();
        ArrayList<IData> out = new ArrayList<IData>(byteArray.length);
        for (byte b : byteArray) {
            out.add(new ByteData(b));
        }
        return out;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayData that = (ByteArrayData)o;
        return this.internal.equals((Object)that.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }
}

