/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketValidator;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.BracketHandlers;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.state.BlockState;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketValidators")
@Document(value="vanilla/api/BracketValidators")
public class BracketValidators {
    private BracketValidators() {
    }

    @ZenCodeType.Method
    @BracketValidator(value="block")
    public static boolean validateBlockBracket(String tokens) {
        return BracketValidators.validateBracket("block", tokens, BracketHandlers::getBlock);
    }

    @ZenCodeType.Method
    @BracketValidator(value="material")
    public static boolean validateBlockMaterialBracket(String tokens) {
        return BracketValidators.validateBracket("material", tokens, BracketHandlers::getMaterial);
    }

    @ZenCodeType.Method
    @BracketValidator(value="blockstate")
    public static boolean validateBlockStateMaterialBracket(String tokens) {
        String[] split = tokens.split(":");
        if (split.length > 4 || split.length < 2) {
            CraftTweakerAPI.LOGGER.error("Invalid BEP Syntax: <blockstate:{}>! Correct syntax is <blockstate:modid:block_name:properties> or <blockstate:modid:block_name>!", (Object)tokens);
            return false;
        }
        String resourceLocation = split[0] + ":" + split[1];
        if (ResourceLocation.tryParse((String)resourceLocation) == null) {
            CraftTweakerAPI.LOGGER.error("Invalid Block name for Blockstate BEP. '{}' does not appear to be a valid resource location!", (Object)resourceLocation);
            return false;
        }
        String properties = split.length == 3 ? split[2] : "";
        BlockState blockState = BracketHandlers.getBlockState(resourceLocation, properties);
        return blockState != null;
    }

    @ZenCodeType.Method
    @BracketValidator(value="mobeffect")
    public static boolean validateEffectBracket(String tokens) {
        if (tokens.split(":").length != 2) {
            CraftTweakerAPI.LOGGER.error("Invalid Bracket Syntax: <effect:" + tokens + ">! Syntax is <effect:modid:potionname>");
            return false;
        }
        return BracketValidators.validateBracket("effect", tokens, BracketHandlers::getMobEffect);
    }

    @ZenCodeType.Method
    @BracketValidator(value="enchantment")
    public static boolean validateEnchantment(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("Enchantment BEP <enchantment:{}> does not seem to be lower-case!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            CraftTweakerAPI.LOGGER.error("Could not get enchantment '{}': not a valid bracket handler, syntax is <enchantment:modid:name>", (Object)tokens);
            return false;
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!Services.REGISTRY.enchantments().containsKey(key)) {
            CraftTweakerAPI.LOGGER.error("Could not get enchantment '{}': the enchantment isn't registered", (Object)tokens);
            return false;
        }
        return true;
    }

    @ZenCodeType.Method
    @BracketValidator(value="entitytype")
    public static boolean validateEntityType(String tokens) {
        if (ResourceLocation.tryParse((String)tokens) == null) {
            CraftTweakerAPI.LOGGER.error("Invalid Bracket Syntax: <entitytype:" + tokens + ">! Syntax is <entitytype:modid:entity_type_name>");
            return false;
        }
        return BracketValidators.validateBracket("entitytype", tokens, BracketHandlers::getEntityType);
    }

    @ZenCodeType.Method
    @BracketValidator(value="item")
    public static boolean validateItemBracket(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("Item BEP <item:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            CraftTweakerAPI.LOGGER.error("Could not get item with name: <item:" + tokens + ">! Syntax is <item:modid:itemname>");
            return false;
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (!Services.REGISTRY.items().containsKey(key)) {
            CraftTweakerAPI.LOGGER.error("Could not get item with name: <item:" + tokens + ">! Item does not appear to exist!");
            return false;
        }
        return true;
    }

    @ZenCodeType.Method
    @BracketValidator(value="profession")
    public static boolean validateProfessionBracket(String tokens) {
        if (tokens.split(":").length != 2) {
            CraftTweakerAPI.LOGGER.error("Invalid Bracket Syntax: <profession:" + tokens + ">! Syntax is <profession:modid:profession_name>");
            return false;
        }
        return BracketValidators.validateBracket("profession", tokens, BracketHandlers::getProfession);
    }

    @ZenCodeType.Method
    @BracketValidator(value="resource")
    public static boolean validateResourceBracket(String tokens) {
        return ResourceLocation.tryParse((String)tokens) != null;
    }

    @ZenCodeType.Method
    @BracketValidator(value="creativemodetab")
    public static boolean validateCreativeModeTabBracket(String tokens) {
        return Arrays.stream(CreativeModeTab.TABS).anyMatch(group -> group.getRecipeFolderName().equals(tokens));
    }

    public static boolean validateBracket(String bracketName, String tokens, Function<String, ?> bracketMethod, boolean logError) {
        try {
            return bracketMethod.apply(tokens) != null;
        }
        catch (Exception e) {
            if (logError) {
                CraftTweakerAPI.LOGGER.error("Error validating BEP <{}:{}>", (Object)bracketName, (Object)tokens, (Object)e);
            }
            return false;
        }
    }

    public static boolean validateBracket(String bracketName, String tokens, Function<String, ?> bracketMethod) {
        return BracketValidators.validateBracket(bracketName, tokens, bracketMethod, true);
    }

    @ZenCodeType.Method
    @BracketValidator(value="soundevent")
    public static boolean validateSoundEvent(String tokens) {
        if (tokens.split(":").length != 2) {
            CraftTweakerAPI.LOGGER.error("Invalid Bracket Syntax: <soundevent:" + tokens + ">! Syntax is <soundevent:modid:name>");
            return false;
        }
        return BracketValidators.validateBracket("soundevent", tokens, BracketHandlers::getSoundEvent);
    }
}

