/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe;

import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.platform.Services;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.Logger;

public class ActionRemoveRecipeByOutputInput<T extends Recipe<?>>
extends ActionRemoveRecipe<T> {
    private final IIngredient output;
    private final IIngredient input;

    public ActionRemoveRecipeByOutputInput(IRecipeManager<T> manager, IIngredient output, IIngredient input) {
        super(manager, (T recipe) -> {
            ItemStack recipeOutput = recipe.getResultItem();
            if (output.matches(Services.PLATFORM.createMCItemStackMutable(recipeOutput))) {
                for (IItemStack item : input.getItems()) {
                    if (!((Ingredient)recipe.getIngredients().get(0)).test(item.getInternal())) continue;
                    return true;
                }
            }
            return false;
        }, (ActionRecipeBase<T> action) -> "Removing \"" + action.getRecipeTypeName() + "\" recipes that output: " + output + "\" from an input of: " + input.getCommandString());
        this.output = output;
        this.input = input;
    }

    @Override
    public boolean validate(Logger logger) {
        if (this.output == null) {
            logger.warn("output cannot be null!", (Throwable)new IllegalArgumentException("output IItemStack cannot be null!"));
            return false;
        }
        if (this.input == null) {
            logger.warn("input cannot be null!", (Throwable)new IllegalArgumentException("input IIngredient cannot be null!"));
            return false;
        }
        return true;
    }
}

