/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.misc;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.zencode.IScriptLoadSource;
import net.minecraft.world.level.block.ComposterBlock;

public class ActionSetCompostable
implements IUndoableAction {
    private final IItemStack stack;
    private final float newValue;
    private final float oldValue;

    public ActionSetCompostable(IItemStack stack, float newValue) {
        this.stack = stack;
        this.newValue = newValue;
        this.oldValue = ComposterBlock.COMPOSTABLES.getOrDefault((Object)stack.getInternal().getItem(), -1.0f);
    }

    @Override
    public void apply() {
        if (this.newValue <= 0.0f) {
            ComposterBlock.COMPOSTABLES.remove((Object)this.stack.getInternal().getItem());
        } else {
            ComposterBlock.COMPOSTABLES.put((Object)this.stack.getInternal().getItem(), this.newValue);
        }
    }

    @Override
    public String describe() {
        return "Setting Composter value of: " + this.stack.getCommandString() + ", to: " + this.newValue + ", from: " + this.oldValue;
    }

    @Override
    public void undo() {
        if (this.oldValue <= 0.0f) {
            ComposterBlock.COMPOSTABLES.remove((Object)this.stack.getInternal().getItem());
        } else {
            ComposterBlock.COMPOSTABLES.put((Object)this.stack.getInternal().getItem(), this.oldValue);
        }
    }

    @Override
    public String describeUndo() {
        return "Undoing setting Composter value of: " + this.stack.getCommandString() + ", to: " + this.newValue + ", reverting to: " + this.oldValue;
    }

    @Override
    public boolean shouldApplyOn(IScriptLoadSource source) {
        return true;
    }
}

