/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.item;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.zencode.IScriptLoadSource;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessItem;
import net.minecraft.world.food.FoodProperties;

public class ActionSetFood
implements IUndoableAction {
    private final IItemStack stack;
    private final FoodProperties newFood;
    private final FoodProperties oldFood;

    public ActionSetFood(IItemStack stack, FoodProperties newFood, FoodProperties oldFood) {
        this.stack = stack;
        this.newFood = newFood;
        this.oldFood = oldFood;
    }

    @Override
    public void apply() {
        ((AccessItem)this.stack.getInternal().getItem()).crafttweaker$setFoodProperties(this.newFood);
    }

    @Override
    public String describe() {
        if (this.newFood == null) {
            return "Removing food properties of " + this.stack.getCommandString();
        }
        return String.format("Setting food of: %s to food with stats: nutrition: %s, saturation: %s, isMeat: %s, isFastFood: %s, canAlwaysEat: %s, effects: %s", this.stack.getCommandString(), this.newFood.getNutrition(), Float.valueOf(this.newFood.getSaturationModifier()), this.newFood.isMeat(), this.newFood.isFastFood(), this.newFood.canAlwaysEat(), this.newFood.getEffects());
    }

    @Override
    public void undo() {
        ((AccessItem)this.stack.getInternal().getItem()).crafttweaker$setFoodProperties(this.oldFood);
    }

    @Override
    public String describeUndo() {
        return "Undoing modification of food for stack: " + this.stack.getCommandString();
    }

    @Override
    public boolean shouldApplyOn(IScriptLoadSource source) {
        return true;
    }
}

