/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.entries.IInputEntry;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.mixin.AccessInputConstantsKey;
import com.blamejared.controlling.mixin.AccessKeyMapping;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.options.controls.KeyBindsList;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;

public class FreeKeysList
extends CustomList {
    private final KeyBindsScreen controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;
    private final List<KeyMapping> keyBindings;

    public FreeKeysList(KeyBindsScreen controls, Minecraft mcIn) {
        super(controls, mcIn);
        this.height -= 52;
        this.setY(48);
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.clearEntries();
        this.allEntries = new ArrayList();
        this.keyBindings = Arrays.stream(this.mc.options.keyMappings).collect(Collectors.toList());
        this.recalculate();
    }

    public int getBottom() {
        return this.controlsScreen.height - 56;
    }

    public int getRight() {
        return this.controlsScreen.width + 45;
    }

    public void recalculate() {
        this.clearEntries();
        this.allEntries.clear();
        this.addEntry(new HeaderEntry("Available Keys"));
        AccessInputConstantsKey.controlling$getNAME_MAP().values().stream().filter(input -> !input.getName().startsWith("key.keyboard.world")).filter(Predicate.not(arg_0 -> ((InputConstants.Key)InputConstants.UNKNOWN).equals(arg_0))).sorted(Comparator.comparing(o -> o.getDisplayName().getString())).forEach(input -> {
            if (this.keyBindings.stream().noneMatch(keyBinding -> ((AccessKeyMapping)keyBinding).controlling$getKey().equals(input))) {
                int i = this.mc.font.width(input.getDisplayName().getString());
                if (i > this.maxListLabelWidth) {
                    this.maxListLabelWidth = i;
                }
                this.addEntry(new InputEntry((InputConstants.Key)input));
            }
        });
    }

    public class HeaderEntry
    extends KeyBindsList.Entry {
        private final String text;

        public HeaderEntry(String text) {
            this.text = text;
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of();
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of();
        }

        public void renderContent(GuiGraphics guiGraphics, int x, int y, boolean hovered, float partialTicks) {
            guiGraphics.drawCenteredString(FreeKeysList.this.mc.font, (Component)ControllingConstants.COMPONENT_OPTIONS_AVAILABLE_KEYS, Objects.requireNonNull(FreeKeysList.this.mc.screen).width / 2 - this.text.length() / 2, y + FreeKeysList.this.height - 9 - 1, 0xFFFFFF);
        }

        protected void refreshEntry() {
        }
    }

    public class InputEntry
    extends KeyBindsList.Entry
    implements IInputEntry {
        private final InputConstants.Key input;

        public InputEntry(InputConstants.Key input) {
            this.input = input;
        }

        @Override
        public InputConstants.Key getInput() {
            return this.input;
        }

        public void renderContent(GuiGraphics guiGraphics, int x, int y, boolean hovered, float partialTicks) {
            String str = this.input.toString() + " - " + this.input.getValue();
            int length = FreeKeysList.this.mc.font.width(this.input.getDisplayName().getString());
            guiGraphics.drawString(FreeKeysList.this.mc.font, str, this.getContentX(), this.getContentYMiddle() - 4, ARGB.opaque((int)0xFFFFFF));
            Font font = FreeKeysList.this.mc.font;
            List<ClientTooltipComponent> list = List.of(ClientTooltipComponent.create((FormattedCharSequence)this.input.getDisplayName().getVisualOrderText()));
            int n = this.getContentX() + this.getContentWidth() - length - 10;
            int n2 = this.getContentYMiddle() - 4;
            Objects.requireNonNull(FreeKeysList.this.mc.font);
            guiGraphics.renderTooltip(font, list, n, n2 + 9, DefaultTooltipPositioner.INSTANCE, null);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of();
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of();
        }

        protected void refreshEntry() {
        }
    }
}

