/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.api;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.entries.IKeyEntry;
import java.util.Comparator;
import net.minecraft.client.gui.screens.options.controls.KeyBindsList;
import net.minecraft.network.chat.Component;

public enum SortOrder implements Comparator<KeyBindsList.Entry>
{
    NONE("options.sortNone", (o1, o2) -> 0),
    AZ("options.sortAZ", Comparator.comparing(o -> o.getKeyDesc().getString())),
    ZA("options.sortZA", Comparator.comparing(o -> o.getKeyDesc().getString(), Comparator.reverseOrder())),
    KEY_AZ("options.sortKeyAZ", Comparator.comparing(o -> o.getKey().getTranslatedKeyMessage().getString()).thenComparing((? super T o) -> o.getKeyDesc().getString())),
    KEY_ZA("options.sortKeyZA", Comparator.comparing(o -> o.getKey().getTranslatedKeyMessage().getString(), Comparator.reverseOrder()).thenComparing(o -> o.getKeyDesc().getString(), Comparator.reverseOrder()));

    private final Component display;
    private final Comparator<KeyBindsList.Entry> sorter = (o1, o2) -> {
        if (o1 instanceof IKeyEntry) {
            IKeyEntry first = (IKeyEntry)o1;
            if (o2 instanceof IKeyEntry) {
                IKeyEntry second = (IKeyEntry)o2;
                return sorter.compare(first, second);
            }
        }
        throw new IllegalStateException("Cannot sort non 'IKeyEntry'!");
    };

    private SortOrder(String key, Comparator<IKeyEntry> sorter) {
        this.display = ControllingConstants.COMPONENT_OPTIONS_SORT.copy().append(": ").append((Component)Component.translatable((String)key));
    }

    public SortOrder cycle() {
        return SortOrder.values()[(this.ordinal() + 1) % SortOrder.values().length];
    }

    public Component getDisplay() {
        return this.display;
    }

    @Override
    public int compare(KeyBindsList.Entry o1, KeyBindsList.Entry o2) {
        return this.sorter.compare(o1, o2);
    }
}

