package com.blamejared.controlling.api.events;

import com.blamejared.controlling.api.entries.IKeyEntry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;

/**
 * RenderKeyEntryEvent is called at the top of {@link IKeyEntry#render(GuiGraphics, int, int, int, int, int, int, int, boolean, float)}
 * is called, allowing mods to render additional info.
 */
public class KeyEntryRenderEvent extends MutableEvent implements IKeyEntryRenderEvent {
    
    public static final EventBus<KeyEntryRenderEvent> BUS = EventBus.create(KeyEntryRenderEvent.class);
    
    private final IKeyEntry entry;
    
    private final GuiGraphics guiGraphics;
    private final int slotIndex;
    private final int y;
    private final int x;
    private final int rowLeft;
    private final int rowWidth;
    private final int mouseX;
    private final int mouseY;
    private final boolean hovered;
    private final float partialTicks;
    
    public KeyEntryRenderEvent(IKeyEntry entry, GuiGraphics guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        
        this.entry = entry;
        this.guiGraphics = guiGraphics;
        this.slotIndex = slotIndex;
        this.y = y;
        this.x = x;
        this.rowLeft = rowLeft;
        this.rowWidth = rowWidth;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.hovered = hovered;
        this.partialTicks = partialTicks;
    }
    
    public IKeyEntry getEntry() {
        
        return entry;
    }
    
    public GuiGraphics getGuiGraphics() {
        
        return guiGraphics;
    }
    
    public int getSlotIndex() {
        
        return slotIndex;
    }
    
    public int getY() {
        
        return y;
    }
    
    public int getX() {
        
        return x;
    }
    
    public int getRowLeft() {
        
        return rowLeft;
    }
    
    public int getRowWidth() {
        
        return rowWidth;
    }
    
    public int getMouseX() {
        
        return mouseX;
    }
    
    public int getMouseY() {
        
        return mouseY;
    }
    
    public boolean isHovered() {
        
        return hovered;
    }
    
    public float getPartialTicks() {
        
        return partialTicks;
    }
    
}
