package com.blamejared.controlling.api;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.entries.IKeyEntry;
import java.util.Comparator;
import net.minecraft.class_2561;
import net.minecraft.class_459;

public enum SortOrder implements Comparator<class_459.class_461> {
    NONE("options.sortNone", (o1, o2) -> 0),
    AZ("options.sortAZ", Comparator.comparing(o -> o.getKeyDesc()
            .getString())),
    ZA("options.sortZA", Comparator.comparing(o -> o.getKeyDesc()
            .getString(), Comparator.reverseOrder())),
    KEY_AZ("options.sortKeyAZ", Comparator.<IKeyEntry, String> comparing(o -> o.getKey().method_16007()
            .getString()).thenComparing(o -> o.getKeyDesc().getString())),
    KEY_ZA("options.sortKeyZA", Comparator.<IKeyEntry, String> comparing(o -> o.getKey().method_16007()
                    .getString(), Comparator.reverseOrder())
            .thenComparing(o -> o.getKeyDesc().getString(), Comparator.reverseOrder()));
    
    private final class_2561 display;
    private final Comparator<class_459.class_461> sorter;
    
    SortOrder(String key, Comparator<IKeyEntry> sorter) {
        
        this.sorter = (o1, o2) -> {
            if(o1 instanceof IKeyEntry first && o2 instanceof IKeyEntry second) {
                return sorter.compare(first, second);
            }
            throw new IllegalStateException("Cannot sort non 'IKeyEntry'!");
        };
        this.display = ControllingConstants.COMPONENT_OPTIONS_SORT.method_27661()
                .method_27693(": ")
                .method_10852(class_2561.method_43471(key));
    }
    
    public SortOrder cycle() {
        
        return SortOrder.values()[(this.ordinal() + 1) % SortOrder.values().length];
    }
    
    public class_2561 getDisplay() {
        
        return this.display;
    }
    
    @Override
    public int compare(class_459.class_461 o1, class_459.class_461 o2) {
        
        return this.sorter.compare(o1, o2);
    }
}
