package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.DisplayMode;
import com.blamejared.controlling.api.SortOrder;
import com.blamejared.controlling.mixin.AccessKeyBindsScreen;
import com.blamejared.controlling.mixin.AccessKeyMapping;
import com.blamejared.controlling.platform.Services;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.google.common.base.Suppliers;
import org.lwjgl.glfw.GLFW;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_459;
import net.minecraft.class_5244;
import net.minecraft.class_6599;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_8667;

public class NewKeyBindsScreen extends class_6599 {
    
    private AutoCompletingEditBox<class_459.class_461> search;
    private DisplayMode displayMode;
    private SortOrder sortOrder = SortOrder.NONE;
    private class_4185 buttonNone;
    private class_4185 buttonConflicting;
    private class_4185 buttonSort;
    private final DisplayableBoolean confirmingReset = new DisplayableBoolean(false, ControllingConstants.COMPONENT_OPTIONS_CONFIRM_RESET, ControllingConstants.COMPONENT_CONTROLS_RESET_ALL);
    private boolean showFree;
    private Supplier<NewKeyBindsList> newKeyList;
    private Supplier<FreeKeysList> freeKeyList;
    
    public NewKeyBindsScreen(class_437 screen, class_315 settings) {
        
        super(screen, settings);
        this.field_49503.method_48995(48);
        this.field_49503.method_48991(56);
    }
    
    @Override
    protected void method_25426() {
        
        super.method_25426();
        this.search.method_1855(0, false);
    }
    
    @Override
    protected void method_57732() {
        
        int searchX = 340; // default net.minecraft.client.gui.screens.options.controls.KeyBindsList.getRowWidth
        int centerX = this.field_22789 / 2;
        Supplier<List<class_459.class_461>> listSupplier = () -> getCustomList().getAllEntries();
        this.search = new AutoCompletingEditBox<>(field_22793, centerX - searchX / 2, 20, searchX, class_4185.field_39501, search, class_2561.method_43471("selectWorld.search"), ControllingConstants.SEARCHABLE_KEYBINDINGS, listSupplier);
        this.search.addResponder(this::filterKeys);
        
        class_8667 header = this.field_49503.method_48993(class_8667.method_52741(), layoutSettings -> layoutSettings.method_46479(8));
        header.method_52738(new class_7842(this.field_22785, this.field_22793), class_7847::method_46467);
        header.method_52738(this.search, layoutSettings -> layoutSettings.method_46479(4));
        method_48265(this.search);
    }
    
    @Override
    protected void method_60329() {
        
        this.newKeyList = Suppliers.memoize(() -> new NewKeyBindsList(this, this.field_22787));
        this.freeKeyList = Suppliers.memoize(() -> new FreeKeysList(this, this.field_22787));
        // Don't call setKeyBindsList as we don't want to reposition elements right now
        getAccess().controlling$setKeyBindsList(showFree ? this.freeKeyList.get() : this.newKeyList.get());
        this.field_49503.method_48999(getKeyBindsList());
        displayMode = DisplayMode.ALL;
    }
    
    @Override
    protected void method_31387() {
        
        int btnWidth = class_4185.field_39500 / 2 - 1;
        this.resetButton(class_4185.method_46430(confirmingReset.currentDisplay(), PRESS_RESET)
                .method_46431());
        resetButton().field_22763 = canReset();
        
        class_4185 toggleFreeButton = class_4185.method_46430(ControllingConstants.COMPONENT_OPTIONS_TOGGLE_FREE, PRESS_FREE)
                .method_46437(btnWidth, class_4185.field_39501)
                .method_46431();
        
        this.buttonSort = class_4185.method_46430(sortOrder.getDisplay(), PRESS_SORT)
                .method_46437(btnWidth, class_4185.field_39501)
                .method_46431();
        
        this.buttonNone = class_4185.method_46430(ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE, PRESS_NONE)
                .method_46437(btnWidth, class_4185.field_39501)
                .method_46431();
        
        this.buttonConflicting = class_4185.method_46430(ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS, PRESS_CONFLICTING)
                .method_46437(btnWidth, class_4185.field_39501)
                .method_46431();
        
        
        class_7845 grid = this.field_49503.method_48996(new class_7845());
        grid.method_48636(4);
        grid.method_48635(8);
        class_7845.class_7939 rowHelper = grid.method_47610(2);
        class_8667 topLeft = rowHelper.method_47612(class_8667.method_52742());
        topLeft.method_52735(4);
        topLeft.method_52736(toggleFreeButton);
        topLeft.method_52736(this.buttonSort);
        
        class_8667 topRight = rowHelper.method_47612(class_8667.method_52742());
        topRight.method_52735(4);
        topRight.method_52736(this.buttonNone);
        topRight.method_52736(this.buttonConflicting);
        
        rowHelper.method_47612(resetButton());
        rowHelper.method_47612(class_4185.method_46430(class_5244.field_24334, $$0x -> this.method_25419()).method_46431());
    }
    
    @Override
    protected void method_48640() {
        
        super.method_48640();
        resetButton().field_22763 = canReset();
    }
    
    @Override
    public void method_25394(class_332 guiGraphics, int mxPos, int myPos, float partialTicks) {
        
        super.method_25394(guiGraphics, mxPos, myPos, partialTicks);
        this.search.autoComplete().method_25394(guiGraphics, mxPos, myPos, partialTicks);
    }
    
    public class_4185 resetButton() {
        
        return this.getAccess().controlling$getResetButton();
    }
    
    public void resetButton(class_4185 button) {
        
        this.getAccess().controlling$setResetButton(button);
    }
    
    public void filterKeys() {
        
        filterKeys(search.method_1882());
    }
    
    public void filterKeys(String lastSearch) {
        
        getKeyBindsList().method_25396().clear();
        getKeyBindsList().method_25307(0);
        if(lastSearch.isEmpty() && displayMode == DisplayMode.ALL && sortOrder == SortOrder.NONE) {
            getKeyBindsList().method_25396().addAll(getCustomList().getAllEntries());
            return;
        }
        
        Predicate<class_459.class_461> extraPredicate = entry -> true;
        Consumer<List<class_459.class_461>> postConsumer = entries -> {};
        CustomList list = getCustomList();
        
        if(list instanceof NewKeyBindsList) {
            extraPredicate = displayMode.getPredicate();
            postConsumer = entries -> sortOrder.sort(entries);
        }
        list.method_25396()
                .addAll(ControllingConstants.SEARCHABLE_KEYBINDINGS.filterEntries(list.getAllEntries(), lastSearch, extraPredicate));
        postConsumer.accept(list.method_25396());
    }
    
    @Override
    public boolean method_25402(double xpos, double ypos, int buttonId) {
        
        boolean b = super.method_25402(xpos, ypos, buttonId);
        if(!b && search.method_25370() && !search.autoComplete().method_25402(xpos, ypos, buttonId)) {
            search.method_25365(false);
            method_48267();
            b = true;
        }
        return b;
    }
    
    @Override
    public boolean method_25401(double xpos, double ypos, double xDelta, double yDelta) {
        
        if(search.autoComplete().method_25401(xpos, ypos, xDelta, yDelta)) {
            return true;
        }
        return super.method_25401(xpos, ypos, xDelta, yDelta);
    }
    
    @Override
    public boolean method_25404(int key, int scancode, int mods) {
        
        if(!search.method_25370() && this.field_34799 == null) {
            if(method_25441()) {
                if(class_3675.method_15987(class_310.method_1551()
                        .method_22683()
                        .method_4490(), GLFW.GLFW_KEY_F)) {
                    search.method_25365(true);
                    return true;
                }
            }
        }
        if(search.method_25370()) {
            if(key == GLFW.GLFW_KEY_ESCAPE) {
                search.method_25365(false);
                return true;
            }
        }
        if(this.field_34799 != null) {
            Services.PLATFORM.handleKeyPress(this, this.field_21336, key, scancode, mods);
            return true;
        } else {
            return super.method_25404(key, scancode, mods);
        }
    }
    
    private CustomList getCustomList() {
        
        if(this.getKeyBindsList() instanceof CustomList cl) {
            return cl;
        }
        throw new IllegalStateException("keyBindsList('%s') was not an instance of CustomList! You're either too early or another mod is messing with things.".formatted(this.getKeyBindsList()
                .getClass()));
    }
    
    public class_459 getKeyBindsList() {
        
        return getAccess().controlling$getKeyBindsList();
    }
    
    private void setKeyBindsList(class_459 newList) {
        
        getAccess().controlling$setKeyBindsList(newList);
        method_48640();
    }
    
    private AccessKeyBindsScreen getAccess() {
        
        return ((AccessKeyBindsScreen) this);
    }
    
    private boolean canReset() {
        
        for(class_304 key : this.field_21336.field_1839) {
            if(!key.method_1427()) {
                return true;
            }
        }
        return false;
    }
    
    private final class_4185.class_4241 PRESS_RESET = btn -> {
        NewKeyBindsScreen screen = NewKeyBindsScreen.this;
        class_310 minecraft = Objects.requireNonNull(screen.field_22787);
        
        if(!confirmingReset.toggle()) {
            for(class_304 keybinding : minecraft.field_1690.field_1839) {
                Services.PLATFORM.setToDefault(minecraft.field_1690, keybinding);
            }
            
            getKeyBindsList().method_49006();
        }
        btn.method_25355(confirmingReset.currentDisplay());
    };
    
    private final class_4185.class_4241 PRESS_NONE = btn -> {
        if(displayMode == DisplayMode.NONE) {
            buttonNone.method_25355(ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
            displayMode = DisplayMode.ALL;
        } else {
            displayMode = DisplayMode.NONE;
            buttonNone.method_25355(ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            buttonConflicting.method_25355(ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
        }
        filterKeys();
    };
    
    private final class_4185.class_4241 PRESS_SORT = btn -> {
        sortOrder = sortOrder.cycle();
        btn.method_25355(sortOrder.getDisplay());
        filterKeys();
    };
    
    private final class_4185.class_4241 PRESS_CONFLICTING = btn -> {
        if(displayMode == DisplayMode.CONFLICTING) {
            buttonConflicting.method_25355(ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
            displayMode = DisplayMode.ALL;
        } else {
            displayMode = DisplayMode.CONFLICTING;
            buttonConflicting.method_25355(ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            buttonNone.method_25355(ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
        }
        filterKeys();
    };
    
    private final class_4185.class_4241 PRESS_FREE = btn -> {
        method_37066(getKeyBindsList());
        if(showFree) {
            buttonSort.field_22763 = true;
            buttonNone.field_22763 = true;
            buttonConflicting.field_22763 = true;
            resetButton().field_22763 = canReset(); // Fixes
            setKeyBindsList(newKeyList.get());
        } else {
            freeKeyList.get().recalculate();
            buttonSort.field_22763 = false;
            buttonNone.field_22763 = false;
            buttonConflicting.field_22763 = false;
            resetButton().field_22763 = false;
            setKeyBindsList(freeKeyList.get());
        }
        filterKeys();
        method_37063(getKeyBindsList());
        method_25395(getKeyBindsList());
        showFree = !showFree;
    };
    
}