package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.entries.IInputEntry;
import com.blamejared.controlling.mixin.AccessInputConstantsKey;
import com.blamejared.controlling.mixin.AccessKeyMapping;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_6379;
import net.minecraft.class_6599;

public class FreeKeysList extends CustomList {
    
    private final class_6599 controlsScreen;
    private final class_310 mc;
    private int maxListLabelWidth;
    
    private final List<class_304> keyBindings;
    
    public FreeKeysList(class_6599 controls, class_310 mcIn) {
        
        super(controls, mcIn);
        this.field_22759 -= 52;
        this.method_46419(48);
        this.controlsScreen = controls;
        this.mc = mcIn;
        method_25396().clear();
        this.allEntries = new ArrayList<>();
        this.keyBindings = Arrays.stream(mc.field_1690.field_1839).collect(Collectors.toList());
        
        recalculate();
    }
    
    @Override
    public int method_55443() {
        
        return this.controlsScreen.field_22790 - 56;
    }
    
    @Override
    public int method_55442() {
        
        return this.controlsScreen.field_22789 + 45;
    }
    
    public void recalculate() {
        
        method_25396().clear();
        allEntries.clear();
        
        addEntry(new HeaderEntry("Available Keys"));
        AccessInputConstantsKey.controlling$getNAME_MAP()
                .values()
                .stream()
                .filter(input -> !input.method_1441().startsWith("key.keyboard.world"))
                .filter(Predicate.not(class_3675.field_16237::equals))
                .sorted(Comparator.comparing(o -> o.method_27445().getString()))
                .forEach(input -> {
                    if(keyBindings.stream()
                            .noneMatch(keyBinding -> ((AccessKeyMapping) keyBinding).controlling$getKey()
                                    .equals(input))) {
                        int i = mc.field_1772.method_1727(input.method_27445().getString());
                        if(i > this.maxListLabelWidth) {
                            this.maxListLabelWidth = i;
                        }
                        addEntry(new InputEntry(input));
                    }
                });
    }
    
    @Override
    protected int method_25329() {
        
        return super.method_25329() + 15 + 20;
    }
    
    public class InputEntry extends class_461 implements IInputEntry {
        private final class_3675.class_306 input;
        
        public InputEntry(class_3675.class_306 input) {
            
            this.input = input;
        }
        
        public class_3675.class_306 getInput() {
            
            return input;
        }
        
        @Override
        public void method_25343(class_332 guiGraphics, int slotIndex, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            
            String str = this.input.toString() + " - " + input.method_1444();
            int length = mc.field_1772.method_1727(input.method_27445().getString());
            
            guiGraphics.method_25303(FreeKeysList.this.mc.field_1772, str, x,  y + height / 2 - 9 / 2, 16777215);
            guiGraphics.method_51438(FreeKeysList.this.mc.field_1772, input.method_27445(), x + width - (length), y + height);
        }
        
        @Override
        public List<? extends class_6379> method_37025() {
            
            return ImmutableList.of();
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            
            return ImmutableList.of();
        }
        
        @Override
        protected void method_48269() {
        
        }
        
    }
    
    public class HeaderEntry extends class_461 {
        private final String text;
        
        public HeaderEntry(String text) {
            
            this.text = text;
        }
        
        @Override
        public List<? extends class_6379> method_37025() {
            
            return ImmutableList.of();
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            
            return ImmutableList.of();
        }
        
        @Override
        public void method_25343(class_332 guiGraphics, int slotIndex, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            guiGraphics.method_27534(mc.field_1772, ControllingConstants.COMPONENT_OPTIONS_AVAILABLE_KEYS, (Objects.requireNonNull(mc.field_1755).field_22789 / 2 - this.text.length() / 2), (y + height - 9 - 1), 16777215);
        }
    
        @Override
        protected void method_48269() {
        
        }
    
    }
    
}