package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.entries.ICategoryEntry;
import com.blamejared.controlling.api.entries.IKeyEntry;
import com.blamejared.controlling.api.events.IKeyEntryListenersEvent;
import com.blamejared.controlling.api.events.IKeyEntryMouseClickedEvent;
import com.blamejared.controlling.api.events.IKeyEntryMouseReleasedEvent;
import com.blamejared.controlling.platform.Services;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_459;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6599;
import net.minecraft.class_7919;
import net.minecraft.class_8012;
import net.minecraft.class_8016;
import net.minecraft.class_8023;

public class NewKeyBindsList extends CustomList {
    
    private final class_6599 controlsScreen;
    private final class_310 mc;
    private int maxListLabelWidth;
    
    public NewKeyBindsList(class_6599 controls, class_310 mcIn) {
        
        super(controls, mcIn);
        this.field_22759 -= 52;
        this.method_46419(48);
        this.controlsScreen = controls;
        this.mc = mcIn;
        method_25396().clear();
        allEntries = new ArrayList<>();
        class_304[] bindings = ArrayUtils.clone(mcIn.field_1690.field_1839);
        Arrays.sort(bindings);
        String lastCategory = null;
        
        for(class_304 keybinding : bindings) {
            String category = keybinding.method_1423();
            if(!category.equals(lastCategory)) {
                lastCategory = category;
                if(!category.endsWith(".hidden")) {
                    addEntry(new NewKeyBindsList.CategoryEntry(class_2561.method_43471(category)));
                }
            }
            
            class_2561 component = Services.PLATFORM.getKeyName(keybinding);
            int width = mcIn.field_1772.method_27525(component);
            if(width > this.maxListLabelWidth) {
                this.maxListLabelWidth = width;
            }
            if(!category.endsWith(".hidden")) {
                addEntry(new NewKeyBindsList.KeyEntry(keybinding, component));
            }
        }
        
    }
    
    @Override
    public int method_55443() {
        
        return this.controlsScreen.field_22790 - 56;
    }
    
    public class CategoryEntry extends class_461 implements ICategoryEntry {
        
        private final class_2561 name;
        private final int labelWidth;
        
        public CategoryEntry(class_2561 name) {
            
            this.name = name;
            this.labelWidth = NewKeyBindsList.this.mc.field_1772.method_27525(this.name);
        }
        
        public void method_25343(class_332 guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            
            guiGraphics.method_27535(NewKeyBindsList.this.mc.field_1772, this.name, Objects.requireNonNull(field_22740.field_1755).field_22789 / 2 - this.labelWidth / 2, y + rowWidth - 9 - 1, 16777215);
        }
        
        public List<? extends class_6379> method_37025() {
            
            return ImmutableList.of(new class_6379() {
                public class_6380 method_37018() {
                    
                    return class_6380.field_33785;
                }
                
                public void method_37020(class_6382 neo) {
                    
                    neo.method_37034(class_6381.field_33788, name);
                }
            });
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            
            return Collections.emptyList();
        }
        
        @Nullable
        @Override
        public class_8016 method_48205(class_8023 $$0) {
            
            return null;
        }
        
        @Override
        protected void method_48269() {
        
        }
        
        
        public class_2561 name() {
            
            return name;
        }
        
    }
    
    public class KeyEntry extends class_459.class_461 implements IKeyEntry {
        
        /**
         * The keybinding specified for this KeyEntry
         */
        private final class_304 key;
        /**
         * The localized key description for this KeyEntry
         */
        private final class_2561 keyDesc;
        private final class_4185 btnChangeKeyBinding;
        private final class_4185 btnResetKeyBinding;
        
        private boolean hasCollision;
        
        private final class_2561 categoryName;
        
        public KeyEntry(final class_304 key, final class_2561 keyDesc) {
            
            this.key = key;
            this.keyDesc = keyDesc;
            this.btnChangeKeyBinding = class_4185.method_46430(this.keyDesc, (btn) -> {
                        NewKeyBindsList.this.controlsScreen.field_34799 = key;
                        NewKeyBindsList.this.method_49006();
                    })
                    .method_46434(0, 0, 75, 20)
                    .method_46435(supp -> key.method_1415() ? class_2561.method_43469("narrator.controls.unbound", keyDesc) : class_2561.method_43469("narrator.controls.bound", keyDesc, supp.get()))
                    .method_46431();
            
            this.btnResetKeyBinding = class_4185.method_46430(ControllingConstants.COMPONENT_CONTROLS_RESET, btn -> {
                        Services.PLATFORM.setToDefault(field_22740.field_1690, key);
                        NewKeyBindsList.this.method_49006();
                    }).method_46434(0, 0, 50, 20)
                    .method_46435(supp -> class_2561.method_43469("narrator.controls.reset", keyDesc))
                    .method_46431();
            
            this.categoryName = class_2561.method_43471(this.key.method_1423());
            method_48269();
        }
        
        @Override
        public void method_25343(class_332 guiGraphics, int slotIndex, int y, int x, int rowLeft, int rowWidth, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            
            Services.EVENT.fireKeyEntryRenderEvent(this, guiGraphics, slotIndex, y, x, rowLeft, rowWidth, mouseX, mouseY, hovered, partialTicks);
            
            int resetKeyX = NewKeyBindsList.this.method_25329() - this.btnResetKeyBinding.method_25368() - 10;
            this.btnResetKeyBinding.method_46421(resetKeyX);
            int top = y - 2;
            this.btnResetKeyBinding.method_46419(top);
            this.btnResetKeyBinding.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            
            this.btnChangeKeyBinding.method_46421(resetKeyX - 5 - this.btnChangeKeyBinding.method_25368());
            this.btnChangeKeyBinding.method_46419(top);
            
            guiGraphics.method_27535(NewKeyBindsList.this.mc.field_1772, this.keyDesc, x, (y + rowWidth / 2) - (9 / 2), class_8012.field_42973);
            
            if(this.hasCollision) {
                int markerWidth = 3;
                int minX = this.btnChangeKeyBinding.method_46426() - 6;
                guiGraphics.method_25294(minX, y + 2, minX + markerWidth, y + rowWidth + 2, class_8012.field_41758);
            }
            this.btnChangeKeyBinding.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        
        public List<class_364> method_25396() {
            
            return Services.EVENT.fireKeyEntryListenersEvent(this)
                    .map(IKeyEntryListenersEvent::getListeners, UnaryOperator.identity());
        }
        
        public List<? extends class_6379> method_37025() {
            
            return ImmutableList.of(this.btnChangeKeyBinding, this.btnResetKeyBinding);
        }
        
        @Override
        public boolean method_25402(double mouseX, double mouseY, int buttonId) {
            
            if(Services.EVENT.fireKeyEntryMouseClickedEvent(this, mouseX, mouseY, buttonId)
                    .map(IKeyEntryMouseClickedEvent::isHandled, UnaryOperator.identity())) {
                return true;
            }
            return super.method_25402(mouseX, mouseY, buttonId);
        }
        
        
        @Override
        public boolean method_25406(double mouseX, double mouseY, int buttonId) {
            
            if(Services.EVENT.fireKeyEntryMouseReleasedEvent(this, mouseX, mouseY, buttonId)
                    .map(IKeyEntryMouseReleasedEvent::isHandled, UnaryOperator.identity())) {
                return true;
            }
            
            return super.method_25406(mouseX, mouseY, buttonId);
        }
        
        public class_304 getKey() {
            
            return key;
        }
        
        public class_2561 getKeyDesc() {
            
            return keyDesc;
        }
        
        public class_2561 categoryName() {
            
            return categoryName;
        }
        
        public class_4185 getBtnResetKeyBinding() {
            
            return btnResetKeyBinding;
        }
        
        public class_4185 getBtnChangeKeyBinding() {
            
            return btnChangeKeyBinding;
        }
        
        @Override
        protected void method_48269() {
            
            this.btnChangeKeyBinding.method_25355(this.key.method_16007());
            this.btnResetKeyBinding.field_22763 = !this.key.method_1427();
            this.hasCollision = false;
            class_5250 duplicates = class_2561.method_43473();
            if(!this.key.method_1415()) {
                class_304[] mappings = NewKeyBindsList.this.field_22740.field_1690.field_1839;
                
                for(class_304 mapping : mappings) {
                    if(mapping != this.key && this.key.method_1435(mapping) || Services.PLATFORM.hasConflictingModifier(key, mapping)) {
                        if(this.hasCollision) {
                            duplicates.method_27693(", ");
                        }
                        
                        this.hasCollision = true;
                        duplicates.method_10852(Services.PLATFORM.getKeyName(mapping));
                    }
                }
            }
            class_5250 tooltip = class_2561.method_43471(key.method_1423());
            if(this.hasCollision) {
                this.btnChangeKeyBinding.method_25355(class_2561.method_43470("[ ")
                        .method_10852(this.btnChangeKeyBinding.method_25369().method_27661().method_27692(class_124.field_1068))
                        .method_27693(" ]")
                        .method_27692(class_124.field_1061));
                tooltip.method_10852(class_5244.field_33849);
                tooltip.method_10852(class_2561.method_43469("controls.keybinds.duplicateKeybinds", duplicates));
            }
            this.btnChangeKeyBinding.method_47400(class_7919.method_47407(tooltip));
            
            if(NewKeyBindsList.this.controlsScreen.field_34799 == this.key) {
                this.btnChangeKeyBinding.method_25355(class_2561.method_43470("> ")
                        .method_10852(this.btnChangeKeyBinding.method_25369()
                                .method_27661()
                                .method_27695(class_124.field_1068, class_124.field_1073))
                        .method_27693(" <")
                        .method_27692(class_124.field_1054));
            }
            
        }
        
    }
    
}