package com.blamejared.controlling;

import com.blamejared.controlling.api.entries.ICategoryEntry;
import com.blamejared.controlling.api.entries.IInputEntry;
import com.blamejared.controlling.api.entries.IKeyEntry;
import com.blamejared.searchables.api.SearchableComponent;
import com.blamejared.searchables.api.SearchableType;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_459;
import net.minecraft.class_5250;

public class ControllingConstants {
    
    public static final class_5250 COMPONENT_CONTROLS_RESET = class_2561.method_43471("controls.reset");
    public static final class_5250 COMPONENT_CONTROLS_RESET_ALL = class_2561.method_43471("controls.resetAll");
    public static final class_5250 COMPONENT_OPTIONS_CONFIRM_RESET = class_2561.method_43471("options.confirmReset");
    public static final class_5250 COMPONENT_OPTIONS_SHOW_NONE = class_2561.method_43471("options.showNone");
    public static final class_5250 COMPONENT_OPTIONS_SHOW_ALL = class_2561.method_43471("options.showAll");
    public static final class_5250 COMPONENT_OPTIONS_SHOW_CONFLICTS = class_2561.method_43471("options.showConflicts");
    public static final class_5250 COMPONENT_OPTIONS_SORT = class_2561.method_43471("options.sort");
    public static final class_5250 COMPONENT_OPTIONS_TOGGLE_FREE = class_2561.method_43471("options.toggleFree");
    public static final class_5250 COMPONENT_OPTIONS_AVAILABLE_KEYS = class_2561.method_43471("options.availableKeys");
    
    
    public static final SearchableType<class_459.class_461> SEARCHABLE_KEYBINDINGS = new SearchableType.Builder<class_459.class_461>()
            .component(SearchableComponent.create("category", entry -> {
                if(entry instanceof ICategoryEntry cat) {
                    return Optional.of(cat.name().getString());
                } else if(entry instanceof IKeyEntry key) {
                    return Optional.of(key.categoryName().getString());
                }
                return Optional.empty();
            }))
            .component(SearchableComponent.create("key", entry -> {
                if(entry instanceof IKeyEntry key) {
                    return Optional.of(key.getKey().method_16007().getString());
                }
                return Optional.empty();
            }))
            .defaultComponent(SearchableComponent.create("name", entry -> {
                if(entry instanceof IKeyEntry key) {
                    return Optional.of(key.getKeyDesc().getString());
                } else if(entry instanceof IInputEntry input) {
                    return Optional.of(input.getInput().method_1441());
                }
                return Optional.empty();
            }))
            .build();
    
    
}
