package com.blamejared.clumps.api.events;

import net.minecraft.class_1657;

/**
 * Used to mutate the value of experience before repairing player's items and giving the rest to the player.
 */
public class ValueEvent implements IValueEvent {
    
    private final class_1657 player;
    private int value;
    
    public ValueEvent(class_1657 player, int value) {
        
        this.player = player;
        this.value = value;
    }
    
    /**
     * Sets the value of the experience orb.
     *
     * @param value The new value to set.
     */
    @Override
    public void setValue(int value) {
        
        this.value = value;
    }
    
    /**
     * Gets the value of the experience orb.
     *
     * @return The value of the experience orb.
     */
    @Override
    public int getValue() {
        
        return this.value;
    }
    
    /**
     * Gets the player that the experience is being given to.
     *
     * @return The player the experience is being given to.
     */
    @Override
    public class_1657 getPlayer() {
        
        return this.player;
    }
    
}