/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.api.unification.ModPriorities;
import com.almostreliable.unified.api.unification.Placeholders;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.Defaults;
import com.almostreliable.unified.unification.ModPrioritiesImpl;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public final class UnificationConfig
extends Config {
    private static final String SUB_FOLDER = "unification";
    private final List<String> modPriorities;
    private final Map<TagKey<Item>, String> priorityOverrides;
    private final List<String> stoneVariants;
    private final List<String> tags;
    private final Set<TagKey<Item>> ignoredTags;
    private final Set<Pattern> ignoredItems;
    private final Set<Pattern> ignoredRecipeTypes;
    private final Set<Pattern> ignoredRecipeIds;
    private final boolean recipeViewerHiding;
    private final boolean lootUnification;
    private final Set<Pattern> ignoredLootTables;
    private final Map<ResourceLocation, Boolean> ignoredItemsCache = new HashMap<ResourceLocation, Boolean>();
    private final Map<ResourceLocation, Boolean> ignoredRecipeTypesCache = new HashMap<ResourceLocation, Boolean>();
    private final Map<ResourceLocation, Boolean> ignoredRecipeIdsCache = new HashMap<ResourceLocation, Boolean>();
    private final Map<ResourceLocation, Boolean> ignoredLootTablesCache = new HashMap<ResourceLocation, Boolean>();
    @Nullable
    private Set<TagKey<Item>> bakedTags;

    private UnificationConfig(String name, List<String> modPriorities, Map<TagKey<Item>, String> priorityOverrides, List<String> stoneVariants, List<String> tags, Set<TagKey<Item>> ignoredTags, Set<Pattern> ignoredItems, Set<Pattern> ignoredRecipeTypes, Set<Pattern> ignoredRecipeIds, boolean recipeViewerHiding, boolean lootUnification, Set<Pattern> ignoredLootTables) {
        super(name);
        this.modPriorities = modPriorities;
        this.priorityOverrides = priorityOverrides;
        this.stoneVariants = stoneVariants;
        this.tags = tags;
        this.ignoredTags = ignoredTags;
        this.ignoredItems = ignoredItems;
        this.ignoredRecipeTypes = ignoredRecipeTypes;
        this.ignoredRecipeIds = ignoredRecipeIds;
        this.recipeViewerHiding = recipeViewerHiding;
        this.lootUnification = lootUnification;
        this.ignoredLootTables = ignoredLootTables;
    }

    public static Collection<UnificationConfig> safeLoadConfigs() {
        try {
            return UnificationConfig.loadConfigs();
        }
        catch (Exception e) {
            AlmostUnifiedCommon.LOGGER.error("Could not load unify configs.", (Throwable)e);
            return List.of();
        }
    }

    private static Collection<UnificationConfig> loadConfigs() throws IOException {
        Path subFolder = UnificationConfig.createConfigDir().resolve(SUB_FOLDER);
        Map<String, JsonObject> jsons = UnificationConfig.readJsons(subFolder);
        if (jsons.isEmpty()) {
            String name = "materials";
            UnifySerializer serializer = new UnifySerializer(name);
            UnificationConfig defaultConfig = (UnificationConfig)serializer.deserialize(new JsonObject());
            UnificationConfig.save(subFolder.resolve(name + ".json"), defaultConfig, serializer);
            return List.of(defaultConfig);
        }
        ArrayList<UnificationConfig> configs = new ArrayList<UnificationConfig>();
        for (Map.Entry<String, JsonObject> entry : jsons.entrySet()) {
            String name = entry.getKey();
            JsonObject json = entry.getValue();
            UnifySerializer serializer = new UnifySerializer(name);
            UnificationConfig config = (UnificationConfig)serializer.deserialize(json);
            if (serializer.isInvalid()) {
                UnificationConfig.save(subFolder.resolve(name + ".json"), config, serializer);
            }
            configs.add(config);
        }
        UnificationConfig.logMissingPriorityMods(configs);
        return configs;
    }

    private static Map<String, JsonObject> readJsons(Path subFolder) throws IOException {
        Files.createDirectories(subFolder, new FileAttribute[0]);
        Collection files = FileUtils.listFiles((File)subFolder.toFile(), (String[])new String[]{"json"}, (boolean)false);
        HashMap<String, JsonObject> jsons = new HashMap<String, JsonObject>();
        for (File file : files) {
            String fileName = FilenameUtils.getBaseName((String)file.getName());
            try {
                jsons.put(fileName, JsonUtils.readFromFile(file.toPath(), JsonObject.class));
            }
            catch (Throwable e) {
                AlmostUnifiedCommon.LOGGER.error("Unify config '{}.json' could not be loaded.", (Object)fileName, (Object)e);
            }
        }
        return jsons;
    }

    private static void logMissingPriorityMods(Collection<UnificationConfig> unificationConfigs) {
        Set mods = unificationConfigs.stream().map(UnificationConfig::getModPriorities).flatMap(ModPriorities::stream).filter(m -> !AlmostUnifiedPlatform.INSTANCE.isModLoaded((String)m)).collect(Collectors.toSet());
        if (mods.isEmpty()) {
            return;
        }
        AlmostUnifiedCommon.LOGGER.warn("The following mods are used in unification settings, but are not loaded: {}", mods);
    }

    public ModPriorities getModPriorities() {
        return new ModPrioritiesImpl(this.modPriorities, this.priorityOverrides);
    }

    public List<String> getStoneVariants() {
        return this.stoneVariants;
    }

    public Set<TagKey<Item>> getTags() {
        if (this.bakedTags == null) {
            throw new IllegalStateException("unification tags are not baked yet");
        }
        return this.bakedTags;
    }

    public Set<TagKey<Item>> bakeTags(Predicate<TagKey<Item>> tagValidator, Placeholders placeholders) {
        if (this.bakedTags != null) {
            return this.bakedTags;
        }
        this.bakedTags = new HashSet<TagKey<Item>>();
        for (String tag : this.tags) {
            Collection<String> replacedTags = placeholders.apply(tag);
            for (String replacedTag : replacedTags) {
                TagKey tagKey;
                ResourceLocation parsedTag = ResourceLocation.tryParse((String)replacedTag);
                if (parsedTag == null || this.ignoredTags.contains(tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)parsedTag)) || !tagValidator.test((TagKey<Item>)tagKey)) continue;
                this.bakedTags.add((TagKey<Item>)tagKey);
            }
        }
        return this.bakedTags;
    }

    public boolean shouldIncludeItem(ResourceLocation item) {
        return this.ignoredItemsCache.computeIfAbsent(item, i -> {
            for (Pattern pattern : this.ignoredItems) {
                if (!pattern.matcher(i.toString()).matches()) continue;
                return false;
            }
            return true;
        });
    }

    public boolean shouldIncludeRecipeType(ResourceLocation type) {
        return this.ignoredRecipeTypesCache.computeIfAbsent(type, t -> {
            for (Pattern pattern : this.ignoredRecipeTypes) {
                if (!pattern.matcher(t.toString()).matches()) continue;
                return false;
            }
            return true;
        });
    }

    public boolean shouldIncludeRecipeId(ResourceLocation id) {
        return this.ignoredRecipeIdsCache.computeIfAbsent(id, i -> {
            for (Pattern pattern : this.ignoredRecipeIds) {
                if (!pattern.matcher(i.toString()).matches()) continue;
                return false;
            }
            return true;
        });
    }

    public boolean shouldHideVariantItems() {
        return this.recipeViewerHiding;
    }

    public boolean shouldUnifyLoot() {
        return this.lootUnification;
    }

    public boolean shouldIncludeLootTable(ResourceLocation table) {
        return this.ignoredLootTablesCache.computeIfAbsent(table, t -> {
            for (Pattern pattern : this.ignoredRecipeIds) {
                if (!pattern.matcher(t.toString()).matches()) continue;
                return false;
            }
            return true;
        });
    }

    public void clearCaches() {
        this.ignoredItemsCache.clear();
        this.ignoredRecipeTypesCache.clear();
        this.ignoredRecipeIdsCache.clear();
        this.ignoredLootTablesCache.clear();
    }

    public static final class UnifySerializer
    extends Config.Serializer<UnificationConfig> {
        private static final String MOD_PRIORITIES = "mod_priorities";
        private static final String PRIORITY_OVERRIDES = "priority_overrides";
        private static final String STONE_VARIANTS = "stone_variants";
        private static final String TAGS = "tags";
        private static final String IGNORED_TAGS = "ignored_tags";
        private static final String IGNORED_ITEMS = "ignored_items";
        private static final String IGNORED_RECIPE_TYPES = "ignored_recipe_types";
        private static final String IGNORED_RECIPES_IDS = "ignored_recipe_ids";
        private static final String RECIPE_VIEWER_HIDING = "recipe_viewer_hiding";
        private static final String LOOT_UNIFICATION = "loot_unification";
        private static final String IGNORED_LOOT_TABLES = "ignored_loot_tables";
        private final String name;

        private UnifySerializer(String name) {
            this.name = name;
        }

        @Override
        public UnificationConfig handleDeserialization(JsonObject json) {
            List<String> modPriorities = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(MOD_PRIORITIES)), Defaults.MOD_PRIORITIES);
            Map priorityOverrides = this.safeGet(() -> JsonUtils.deserializeMap(json, PRIORITY_OVERRIDES, e -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)((String)e.getKey()))), e -> ((JsonElement)e.getValue()).getAsString()), new HashMap());
            List<String> stoneVariants = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(STONE_VARIANTS)), Defaults.STONE_VARIANTS);
            List<String> tags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(TAGS)), Defaults.TAGS);
            Set ignoredTags = this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(IGNORED_TAGS)).stream().map(s -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)s))).collect(Collectors.toSet()), new HashSet());
            Set<Pattern> ignoredItems = this.deserializePatterns(json, IGNORED_ITEMS, List.of());
            Set<Pattern> ignoredRecipeTypes = this.deserializePatterns(json, IGNORED_RECIPE_TYPES, Defaults.IGNORED_RECIPE_TYPES);
            Set<Pattern> ignoredRecipeIds = this.deserializePatterns(json, IGNORED_RECIPES_IDS, List.of());
            boolean recipeViewerHiding = this.safeGet(() -> json.getAsJsonPrimitive(RECIPE_VIEWER_HIDING).getAsBoolean(), true);
            boolean lootUnification = this.safeGet(() -> json.getAsJsonPrimitive(LOOT_UNIFICATION).getAsBoolean(), false);
            Set<Pattern> ignoredLootTables = this.deserializePatterns(json, IGNORED_LOOT_TABLES, List.of());
            return new UnificationConfig(this.name, modPriorities, priorityOverrides, stoneVariants, tags, ignoredTags, ignoredItems, ignoredRecipeTypes, ignoredRecipeIds, recipeViewerHiding, lootUnification, ignoredLootTables);
        }

        @Override
        public JsonObject serialize(UnificationConfig config) {
            JsonObject json = new JsonObject();
            json.add(MOD_PRIORITIES, (JsonElement)JsonUtils.toArray(config.modPriorities));
            JsonObject priorityOverrides = new JsonObject();
            config.priorityOverrides.forEach((tag, mod) -> priorityOverrides.addProperty(tag.location().toString(), mod));
            json.add(PRIORITY_OVERRIDES, (JsonElement)priorityOverrides);
            json.add(STONE_VARIANTS, (JsonElement)JsonUtils.toArray(config.stoneVariants));
            json.add(TAGS, (JsonElement)JsonUtils.toArray(config.tags));
            json.add(IGNORED_TAGS, (JsonElement)JsonUtils.toArray(config.ignoredTags.stream().map(TagKey::location).map(ResourceLocation::toString).toList()));
            this.serializePatterns(json, IGNORED_ITEMS, config.ignoredItems);
            this.serializePatterns(json, IGNORED_RECIPE_TYPES, config.ignoredRecipeTypes);
            this.serializePatterns(json, IGNORED_RECIPES_IDS, config.ignoredRecipeIds);
            json.addProperty(RECIPE_VIEWER_HIDING, Boolean.valueOf(config.recipeViewerHiding));
            json.addProperty(LOOT_UNIFICATION, Boolean.valueOf(config.lootUnification));
            this.serializePatterns(json, IGNORED_LOOT_TABLES, config.ignoredLootTables);
            return json;
        }
    }
}

