/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.Defaults;
import com.almostreliable.unified.unification.recipe.RecipeLink;
import com.almostreliable.unified.utils.JsonCompare;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public final class DuplicateConfig
extends Config {
    public static final String NAME = "duplicates";
    public static final DuplicateSerializer SERIALIZER = new DuplicateSerializer();
    private final JsonCompare.CompareSettings defaultRules;
    private final LinkedHashMap<ResourceLocation, JsonCompare.CompareSettings> overrideRules;
    private final Set<Pattern> ignoreRecipeTypes;
    private final Set<Pattern> ignoreRecipeIds;
    private final boolean compareAll;
    private final Map<ResourceLocation, Boolean> ignoredRecipeTypesCache;

    private DuplicateConfig(JsonCompare.CompareSettings defaultRules, LinkedHashMap<ResourceLocation, JsonCompare.CompareSettings> overrideRules, Set<Pattern> ignoreRecipeTypes, Set<Pattern> ignoreRecipeIds, boolean compareAll) {
        super(NAME);
        this.defaultRules = defaultRules;
        this.overrideRules = overrideRules;
        this.ignoreRecipeTypes = ignoreRecipeTypes;
        this.ignoreRecipeIds = ignoreRecipeIds;
        this.compareAll = compareAll;
        this.ignoredRecipeTypesCache = new HashMap<ResourceLocation, Boolean>();
    }

    public boolean shouldIgnoreRecipe(RecipeLink recipe) {
        if (this.isRecipeTypeIgnored(recipe)) {
            return true;
        }
        for (Pattern ignoreRecipePattern : this.ignoreRecipeIds) {
            if (!ignoreRecipePattern.matcher(recipe.getId().toString()).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isRecipeTypeIgnored(RecipeLink recipe) {
        ResourceLocation type = recipe.getType();
        Boolean ignored = this.ignoredRecipeTypesCache.get(type);
        if (ignored == null) {
            ignored = this.computeIsRecipeTypeIgnored(type.toString());
            this.ignoredRecipeTypesCache.put(type, ignored);
        }
        return ignored;
    }

    private boolean computeIsRecipeTypeIgnored(String recipeType) {
        for (Pattern ignorePattern : this.ignoreRecipeTypes) {
            if (!ignorePattern.matcher(recipeType).matches()) continue;
            return true;
        }
        return false;
    }

    public JsonCompare.CompareSettings getCompareSettings(ResourceLocation type) {
        return this.overrideRules.getOrDefault(type, this.defaultRules);
    }

    public JsonCompare.CompareContext getCompareContext(RecipeLink recipe) {
        JsonCompare.CompareSettings compareSettings = this.getCompareSettings(recipe.getType());
        return JsonCompare.CompareContext.create(compareSettings, recipe);
    }

    public boolean shouldCompareAll() {
        return this.compareAll;
    }

    public void clearCache() {
        this.ignoredRecipeTypesCache.clear();
    }

    public static final class DuplicateSerializer
    extends Config.Serializer<DuplicateConfig> {
        private static final String DEFAULT_DUPLICATE_RULES = "default_duplicate_rules";
        private static final String OVERRIDE_DUPLICATE_RULES = "override_duplicate_rules";
        private static final String IGNORED_RECIPE_TYPES = "ignored_recipe_types";
        private static final String IGNORED_RECIPE_IDS = "ignored_recipe_ids";
        private static final String COMPARE_ALL = "compare_all";

        private DuplicateSerializer() {
        }

        @Override
        public DuplicateConfig handleDeserialization(JsonObject json) {
            AlmostUnifiedPlatform.Platform platform = AlmostUnifiedPlatform.INSTANCE.getPlatform();
            Set<Pattern> ignoreRecipeTypes = this.deserializePatterns(json, IGNORED_RECIPE_TYPES, Defaults.IGNORED_RECIPE_TYPES);
            Set<Pattern> ignoreRecipeIds = this.deserializePatterns(json, IGNORED_RECIPE_IDS, List.of());
            JsonCompare.CompareSettings defaultRules = this.safeGet(() -> this.createCompareSet(json.getAsJsonObject(DEFAULT_DUPLICATE_RULES)), Defaults.getDefaultDuplicateRules(platform));
            LinkedHashMap<ResourceLocation, JsonCompare.CompareSettings> overrideRules = this.safeGet(() -> this.getOverrideRules(json), Defaults.getDefaultDuplicateOverrides(platform));
            boolean compareAll = this.safeGet(() -> json.get(COMPARE_ALL).getAsBoolean(), false);
            return new DuplicateConfig(defaultRules, overrideRules, ignoreRecipeTypes, ignoreRecipeIds, compareAll);
        }

        private LinkedHashMap<ResourceLocation, JsonCompare.CompareSettings> getOverrideRules(JsonObject json) {
            return json.getAsJsonObject(OVERRIDE_DUPLICATE_RULES).entrySet().stream().collect(Collectors.toMap(entry -> ResourceLocation.parse((String)((String)entry.getKey())), entry -> this.createCompareSet(((JsonElement)entry.getValue()).getAsJsonObject()), (a, b) -> b, LinkedHashMap::new));
        }

        private JsonCompare.CompareSettings createCompareSet(JsonObject rules) {
            JsonCompare.CompareSettings result = new JsonCompare.CompareSettings();
            result.deserialize(rules);
            return result;
        }

        @Override
        public JsonObject serialize(DuplicateConfig config) {
            JsonObject json = new JsonObject();
            this.serializePatterns(json, IGNORED_RECIPE_TYPES, config.ignoreRecipeTypes);
            this.serializePatterns(json, IGNORED_RECIPE_IDS, config.ignoreRecipeIds);
            json.add(DEFAULT_DUPLICATE_RULES, (JsonElement)config.defaultRules.serialize());
            JsonObject overrides = new JsonObject();
            config.overrideRules.forEach((rl, compareSettings) -> overrides.add(rl.toString(), (JsonElement)compareSettings.serialize()));
            json.add(OVERRIDE_DUPLICATE_RULES, (JsonElement)overrides);
            json.addProperty(COMPARE_ALL, Boolean.valueOf(false));
            return json;
        }
    }
}

