/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.core;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.unification.Placeholders;
import com.almostreliable.unified.api.unification.TagSubstitutions;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.api.unification.UnificationSettings;
import com.almostreliable.unified.api.unification.recipe.CustomIngredientUnifierRegistry;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifierRegistry;
import com.almostreliable.unified.compat.PluginManager;
import com.almostreliable.unified.compat.viewer.ItemHider;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.DebugConfig;
import com.almostreliable.unified.config.PlaceholderConfig;
import com.almostreliable.unified.config.TagConfig;
import com.almostreliable.unified.config.UnificationConfig;
import com.almostreliable.unified.core.TagReloadHandler;
import com.almostreliable.unified.unification.TagInheritance;
import com.almostreliable.unified.unification.TagSubstitutionsImpl;
import com.almostreliable.unified.unification.UnificationSettingsImpl;
import com.almostreliable.unified.unification.recipe.CustomIngredientUnifierRegistryImpl;
import com.almostreliable.unified.unification.recipe.RecipeTransformer;
import com.almostreliable.unified.unification.recipe.RecipeUnifierRegistryImpl;
import com.almostreliable.unified.utils.DebugHandler;
import com.almostreliable.unified.utils.FileUtils;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class AlmostUnifiedRuntimeImpl
implements AlmostUnifiedRuntime {
    private final Collection<? extends UnificationSettings> unificationSettings;
    private final CustomIngredientUnifierRegistry ingredientUnifierRegistry;
    private final RecipeUnifierRegistry recipeUnifierRegistry;
    private final TagSubstitutions tagSubstitutions;
    private final Placeholders placeholders;
    private final UnificationLookup compositeUnificationLookup;
    private final DebugHandler debugHandler;

    private AlmostUnifiedRuntimeImpl(Collection<? extends UnificationSettings> unificationSettings, CustomIngredientUnifierRegistry ingredientUnifierRegistry, RecipeUnifierRegistry recipeUnifierRegistry, TagSubstitutions tagSubstitutions, Placeholders placeholders, DebugConfig debugConfig) {
        this.unificationSettings = unificationSettings;
        this.ingredientUnifierRegistry = ingredientUnifierRegistry;
        this.recipeUnifierRegistry = recipeUnifierRegistry;
        this.tagSubstitutions = tagSubstitutions;
        this.placeholders = placeholders;
        this.compositeUnificationLookup = new CompositeUnificationLookup(unificationSettings);
        this.debugHandler = new DebugHandler(debugConfig);
    }

    public static AlmostUnifiedRuntimeImpl create(VanillaTagWrapper<Item> itemTags, VanillaTagWrapper<Block> blockTags) {
        AlmostUnifiedCommon.LOGGER.warn("Reload detected. Reconstructing runtime.");
        FileUtils.createGitIgnore();
        DebugConfig debugConfig = Config.load("debug", DebugConfig.SERIALIZER);
        PlaceholderConfig placeholderConfig = Config.load("placeholders", PlaceholderConfig.SERIALIZER);
        TagConfig tagConfig = Config.load("tags", TagConfig.SERIALIZER);
        Collection<UnificationConfig> unificationConfigs = UnificationConfig.safeLoadConfigs();
        TagReloadHandler.applyCustomTags(tagConfig.getCustomTags(), itemTags);
        CustomIngredientUnifierRegistryImpl ingredientUnifierRegistry = new CustomIngredientUnifierRegistryImpl();
        PluginManager.instance().registerCustomIngredientUnifiers(ingredientUnifierRegistry);
        RecipeUnifierRegistryImpl recipeUnifierRegistry = new RecipeUnifierRegistryImpl();
        PluginManager.instance().registerRecipeUnifiers(recipeUnifierRegistry);
        Set<TagKey<Item>> unificationTags = AlmostUnifiedRuntimeImpl.bakeAndValidateTags(unificationConfigs, itemTags, placeholderConfig, debugConfig.shouldLogInvalidTags());
        TagSubstitutionsImpl tagSubstitutions = TagSubstitutionsImpl.create(itemTags::has, unificationTags::contains, tagConfig.getTagSubstitutions());
        tagSubstitutions.apply(itemTags);
        List<UnificationSettings> unificationSettings = AlmostUnifiedRuntimeImpl.createUnificationLookups(itemTags, blockTags, unificationConfigs, tagSubstitutions, tagConfig.getTagInheritance());
        ItemHider.applyHideTags(itemTags, unificationSettings, tagConfig.isEmiHidingStrict());
        return new AlmostUnifiedRuntimeImpl(unificationSettings, ingredientUnifierRegistry, recipeUnifierRegistry, tagSubstitutions, placeholderConfig, debugConfig);
    }

    private static Set<TagKey<Item>> bakeAndValidateTags(Collection<UnificationConfig> unificationConfigs, VanillaTagWrapper<Item> itemTags, Placeholders placeholders, boolean logInvalidTags) {
        HashSet<TagKey<Item>> result = new HashSet<TagKey<Item>>();
        HashMap visitedTags = new HashMap();
        HashSet wrongTags = new HashSet();
        for (UnificationConfig config : unificationConfigs) {
            Predicate<TagKey<Item>> validator = tag -> {
                if (!itemTags.has((TagKey<Item>)tag)) {
                    wrongTags.add(tag);
                    return false;
                }
                if (visitedTags.containsKey(tag)) {
                    AlmostUnifiedCommon.LOGGER.warn("Tag '{}' from unify config '{}' was already created in unify config '{}'", (Object)config.getName(), (Object)tag.location(), visitedTags.get(tag));
                    return false;
                }
                visitedTags.put(tag, config.getName());
                return true;
            };
            Set<TagKey<Item>> tags = config.bakeTags(validator, placeholders);
            result.addAll(tags);
        }
        if (!wrongTags.isEmpty() && logInvalidTags) {
            AlmostUnifiedCommon.LOGGER.warn("The following tags are invalid or not in use and will be ignored: {}", wrongTags.stream().map(TagKey::location).collect(Collectors.toList()));
        }
        return result;
    }

    private static List<UnificationSettings> createUnificationLookups(VanillaTagWrapper<Item> itemTags, VanillaTagWrapper<Block> blockTags, Collection<UnificationConfig> unificationConfigs, TagSubstitutionsImpl tagSubstitutions, TagInheritance tagInheritance) {
        List<UnificationSettings> unificationSettings = UnificationSettingsImpl.create(unificationConfigs, itemTags, blockTags, tagSubstitutions);
        boolean needsRebuild = tagInheritance.apply(itemTags, blockTags, unificationSettings);
        if (needsRebuild) {
            return UnificationSettingsImpl.create(unificationConfigs, itemTags, blockTags, tagSubstitutions);
        }
        return unificationSettings;
    }

    public void run(Map<ResourceLocation, JsonElement> recipes) {
        this.debugHandler.onRunStart(recipes, this.compositeUnificationLookup);
        this.debugHandler.measure(() -> new RecipeTransformer(this.ingredientUnifierRegistry, this.recipeUnifierRegistry, this.unificationSettings).transformRecipes(recipes));
        this.debugHandler.onRunEnd(recipes);
    }

    @Override
    public UnificationLookup getUnificationLookup() {
        return this.compositeUnificationLookup;
    }

    @Override
    public Collection<? extends UnificationSettings> getUnificationSettings() {
        return Collections.unmodifiableCollection(this.unificationSettings);
    }

    @Override
    @Nullable
    public UnificationSettings getUnificationSettings(String name) {
        for (UnificationSettings unificationSettings : this.unificationSettings) {
            if (!unificationSettings.getName().equals(name)) continue;
            return unificationSettings;
        }
        return null;
    }

    @Override
    public TagSubstitutions getTagSubstitutions() {
        return this.tagSubstitutions;
    }

    @Override
    public Placeholders getPlaceholders() {
        return this.placeholders;
    }

    public DebugHandler getDebugHandler() {
        return this.debugHandler;
    }

    private static final class CompositeUnificationLookup
    implements UnificationLookup {
        private final Iterable<? extends UnificationLookup> unificationLookups;
        @Nullable
        private Collection<TagKey<Item>> unificationTagsView;

        private CompositeUnificationLookup(Iterable<? extends UnificationLookup> unificationLookups) {
            this.unificationLookups = unificationLookups;
        }

        @Override
        public Collection<TagKey<Item>> getTags() {
            if (this.unificationTagsView == null) {
                HashSet<TagKey<Item>> tagView = new HashSet<TagKey<Item>>();
                for (UnificationLookup unificationLookup : this.unificationLookups) {
                    tagView.addAll(unificationLookup.getTags());
                }
                this.unificationTagsView = Collections.unmodifiableCollection(tagView);
            }
            return this.unificationTagsView;
        }

        @Override
        public Collection<UnificationEntry<Item>> getTagEntries(TagKey<Item> tag) {
            for (UnificationLookup unificationLookup : this.unificationLookups) {
                Collection<UnificationEntry<Item>> resultItems = unificationLookup.getTagEntries(tag);
                if (resultItems.isEmpty()) continue;
                return resultItems;
            }
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public UnificationEntry<Item> getItemEntry(ResourceLocation item) {
            for (UnificationLookup unificationLookup : this.unificationLookups) {
                UnificationEntry<Item> resultItem = unificationLookup.getItemEntry(item);
                if (resultItem == null) continue;
                return resultItem;
            }
            return null;
        }

        @Override
        @Nullable
        public TagKey<Item> getRelevantItemTag(ResourceLocation item) {
            for (UnificationLookup unificationLookup : this.unificationLookups) {
                TagKey<Item> tag = unificationLookup.getRelevantItemTag(item);
                if (tag == null) continue;
                return tag;
            }
            return null;
        }

        @Override
        public UnificationEntry<Item> getVariantItemTarget(ResourceLocation item) {
            for (UnificationLookup unificationLookup : this.unificationLookups) {
                UnificationEntry<Item> resultItem = unificationLookup.getVariantItemTarget(item);
                if (resultItem == null) continue;
                return resultItem;
            }
            return null;
        }

        @Override
        public UnificationEntry<Item> getTagTargetItem(TagKey<Item> tag, Predicate<ResourceLocation> itemFilter) {
            for (UnificationLookup unificationLookup : this.unificationLookups) {
                UnificationEntry<Item> result = unificationLookup.getTagTargetItem(tag, itemFilter);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public boolean isUnifiedIngredientItem(Ingredient ingredient, ItemStack item) {
            for (UnificationLookup unificationLookup : this.unificationLookups) {
                if (!unificationLookup.isUnifiedIngredientItem(ingredient, item)) continue;
                return true;
            }
            return false;
        }
    }
}

