package com.almostreliable.unified.compat;

import F;
import com.almostreliable.unified.recipe.ClientRecipeTracker.ClientRecipeLink;
import com.almostreliable.unified.utils.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

import java.util.List;

final class RecipeIndicator {

    static final int RENDER_SIZE = 10;
    private static final int TEXTURE_SIZE = 16;
    private static final ResourceLocation TEXTURE = Utils.getRL("textures/ingot.png");

    private RecipeIndicator() {}

    static void renderIndicator(GuiGraphics guiGraphics, int pX, int pY, int size) {
        var poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();

        poseStack.m_252880_(pX, pY, 0);
        var scale = size / (float) TEXTURE_SIZE;
        poseStack.m_85841_(scale, scale, scale);
        guiGraphics.m_280163_(TEXTURE, 0, 0, 0, 0, TEXTURE_SIZE, TEXTURE_SIZE, TEXTURE_SIZE, TEXTURE_SIZE);

        poseStack.m_85849_();
    }

    static List<Component> constructTooltip(ClientRecipeLink link) {
        var unified = Component.m_237115_(Utils.prefix("unified")).m_130946_(": ")
                .m_130938_(c -> c.m_131140_(ChatFormatting.AQUA));
        unified.m_7220_(Component.m_237115_(Utils.prefix(link.isUnified() ? "yes" : "no"))
                .m_130938_(c -> c.m_131140_(ChatFormatting.WHITE)));

        var duplicate = Component.m_237115_(Utils.prefix("duplicate")).m_130946_(": ")
                .m_130938_(c -> c.m_131140_(ChatFormatting.AQUA));
        duplicate.m_7220_(Component.m_237115_(Utils.prefix(link.isDuplicate() ? "yes" : "no"))
                .m_130938_(c -> c.m_131140_(ChatFormatting.WHITE)));

        return List.of(
                Component.m_237115_(Utils.prefix("description")).m_130938_(c -> c.m_131140_(ChatFormatting.GOLD)),
                Component.m_237113_(" "),
                unified,
                duplicate,
                Component.m_237113_(" "),
                Component.m_237115_(Utils.prefix("warning")).m_130938_(c -> c.m_131140_(ChatFormatting.RED))
        );
    }

    static void renderTooltip(GuiGraphics guiGraphics, ClientRecipeLink link, double mouseX, double mouseY) {
        var mc = Minecraft.m_91087_();
        var font = mc.f_91062_;
        var screen = mc.f_91080_;
        if (screen == null) return;

        var tooltip = constructTooltip(link).stream()
                .map(c -> font.m_92923_(c, screen.f_96543_ - (int) mouseX - 200))
                .flatMap(List::stream)
                .toList();

        guiGraphics.m_280245_(
                font,
                tooltip,
                (int) mouseX,
                (int) mouseY
        );
    }
}
