package com.almostreliable.unified.utils;

import com.almostreliable.unified.BuildConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

import javax.annotation.Nullable;
import java.util.Iterator;
import java.util.Set;

public final class Utils {
    public static final ResourceLocation UNUSED_ID = new ResourceLocation(BuildConfig.MOD_ID, "unused_id");
    public static final UnifyTag<Item> UNUSED_TAG = UnifyTag.item(UNUSED_ID);

    private Utils() {}

    public static UnifyTag<Item> toItemTag(@Nullable String tag) {
        if (tag == null) {
            return UNUSED_TAG;
        }

        ResourceLocation rl = ResourceLocation.m_135820_(tag);
        if (rl == null) {
            return UNUSED_TAG;
        }

        return UnifyTag.item(rl);
    }

    @SuppressWarnings("unchecked")
    public static <T> T cast(Object o) {
        return (T) o;
    }

    public static ResourceLocation getRL(String path) {
        return new ResourceLocation(BuildConfig.MOD_ID, path);
    }

    public static String prefix(String path) {
        return BuildConfig.MOD_ID + "." + path;
    }

    /**
     * Checks if all ids have the same namespace
     *
     * @param ids set of ids
     * @return true if all ids have the same namespace
     */
    public static boolean allSameNamespace(Set<ResourceLocation> ids) {
        if (ids.size() <= 1) return true;

        var it = ids.iterator();
        var namespace = it.next().m_135827_();

        while (it.hasNext()) {
            if (!it.next().m_135827_().equals(namespace)) return false;
        }

        return true;
    }
}
