package com.almostreliable.unified.core;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.utils.VanillaTagWrapper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

@SuppressWarnings({ "StaticVariableMayNotBeInitialized", "StaticVariableUsedBeforeInitialization" })
public final class TagReloadHandler {

    private static final Object LOCK = new Object();
    @Nullable private static VanillaTagWrapper<class_1792> VANILLA_ITEM_TAGS;
    @Nullable private static VanillaTagWrapper<class_2248> VANILLA_BLOCK_TAGS;

    private TagReloadHandler() {}

    public static void initItemTags(Map<class_2960, Collection<class_6880<class_1792>>> rawItemTags) {
        synchronized (LOCK) {
            VANILLA_ITEM_TAGS = VanillaTagWrapper.of(class_7923.field_41178, rawItemTags);
        }
    }

    public static void initBlockTags(Map<class_2960, Collection<class_6880<class_2248>>> rawBlockTags) {
        synchronized (LOCK) {
            VANILLA_BLOCK_TAGS = VanillaTagWrapper.of(class_7923.field_41175, rawBlockTags);
        }
    }

    public static void run() {
        if (VANILLA_ITEM_TAGS == null || VANILLA_BLOCK_TAGS == null) {
            return;
        }

        AlmostUnifiedCommon.onTagLoaderReload(VANILLA_ITEM_TAGS, VANILLA_BLOCK_TAGS);

        VANILLA_ITEM_TAGS.seal();
        VANILLA_BLOCK_TAGS.seal();
        VANILLA_ITEM_TAGS = null;
        VANILLA_BLOCK_TAGS = null;
    }

    public static void applyCustomTags(Map<class_2960, Set<class_2960>> customTags, VanillaTagWrapper<class_1792> itemTags) {
        Multimap<class_2960, class_2960> changedItemTags = HashMultimap.create();

        for (var entry : customTags.entrySet()) {
            class_2960 tag = entry.getKey();
            Set<class_2960> itemIds = entry.getValue();

            for (class_2960 itemId : itemIds) {
                if (!class_7923.field_41178.method_10250(itemId)) {
                    AlmostUnifiedCommon.LOGGER.warn("[CustomTags] Custom tag '{}' contains invalid item '{}'",
                        tag,
                        itemId);
                    continue;
                }

                class_5321<class_1792> itemKey = class_5321.method_29179(class_7924.field_41197, itemId);
                class_6880<class_1792> itemHolder = class_7923.field_41178.method_40264(itemKey).orElse(null);
                if (itemHolder == null) continue;

                var currentHolders = itemTags.get(tag);

                if (!currentHolders.isEmpty()) {
                    if (currentHolders.contains(itemHolder)) {
                        AlmostUnifiedCommon.LOGGER.warn("[CustomTags] Custom tag '{}' already contains item '{}'",
                            tag,
                            itemId);
                        continue;
                    }
                }

                itemTags.add(tag, itemHolder);
                changedItemTags.put(tag, itemId);
            }
        }

        if (!changedItemTags.isEmpty()) {
            changedItemTags.asMap().forEach(
                (tag, items) -> AlmostUnifiedCommon.LOGGER.info(
                    "[CustomTags] Modified tag '#{}', added {}",
                    tag,
                    items
                )
            );
        }
    }
}
