package com.almostreliable.unified.api.unification;

import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

/**
 * Helper to abstract a single entry used in unification.
 * <p>
 * This helper allows easy access to registry information while also offering utility methods.
 *
 * @param <T> the type of the entry
 * @since 1.0.0
 */
public interface UnificationEntry<T> {

    /**
     * Returns the {@link class_5321} this entry is bound to in the {@link class_2378}.
     *
     * @return the {@link class_5321} this entry is bound to
     */
    class_5321<T> key();

    /**
     * Returns the id of this entry.
     * <p>
     * The id is the {@link class_2960} of the entry in the {@link class_2378}.
     *
     * @return the id of this entry
     */
    class_2960 id();

    /**
     * Returns the raw value of this entry.
     *
     * @return the raw value
     */
    T value();

    /**
     * Returns the tag of this entry.
     * <p>
     * The tag represents the relevant tag used for the unification. Each entry can only have a single unification tag.
     *
     * @return the tag
     */
    class_6862<T> tag();

    /**
     * Returns the value as a {@link class_6880.class_6883}.
     *
     * @return the value holder
     */
    class_6880.class_6883<T> asHolderOrThrow();
}
