/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.StoneVariants;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class StoneVariantsImpl
implements StoneVariants {
    private static final Pattern ORE_TAG_PATTERN = Pattern.compile("(c:ores/.+|(minecraft|c):.+_ores)");
    private final Map<class_6862<class_1792>, Boolean> isOreTagCache = new HashMap<class_6862<class_1792>, Boolean>();
    private final List<String> stoneVariants;
    private final Map<class_2960, String> itemToStoneVariant;

    private StoneVariantsImpl(Collection<String> stoneVariants, Map<class_2960, String> itemToStoneVariant) {
        this.stoneVariants = StoneVariantsImpl.sortStoneVariants(stoneVariants);
        this.itemToStoneVariant = itemToStoneVariant;
    }

    public static StoneVariants create(Collection<String> stoneVariants, VanillaTagWrapper<class_1792> itemTags, VanillaTagWrapper<class_2248> blockTags) {
        class_6862<class_1792> tag;
        class_2960 item;
        HashSet stoneVariantItemTags = new HashSet();
        HashSet stoneVariantBlockTags = new HashSet();
        for (String stoneVariant : stoneVariants) {
            class_2960 id = class_2960.method_60655((String)"c", (String)("ores_in_ground/" + stoneVariant));
            stoneVariantItemTags.add(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)id));
            stoneVariantBlockTags.add(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)id));
        }
        Map<class_2960, class_6862<class_1792>> itemToStoneVariantTag = StoneVariantsImpl.mapEntriesToStoneVariantTags(stoneVariantItemTags, itemTags);
        Map<class_2960, class_6862<class_2248>> blockToStoneVariantTag = StoneVariantsImpl.mapEntriesToStoneVariantTags(stoneVariantBlockTags, blockTags);
        HashMap<class_2960, String> itemToStoneVariant = new HashMap<class_2960, String>();
        for (Map.Entry<class_2960, class_6862<class_1792>> entry : itemToStoneVariantTag.entrySet()) {
            item = entry.getKey();
            tag = entry.getValue();
            String itemTagStoneVariant = StoneVariantsImpl.getVariantFromStoneVariantTag(stoneVariants, tag);
            if (itemTagStoneVariant == null) continue;
            itemToStoneVariant.put(item, itemTagStoneVariant);
        }
        for (Map.Entry<class_2960, class_6862<class_1792>> entry : blockToStoneVariantTag.entrySet()) {
            String itemTagStoneVariant;
            item = entry.getKey();
            tag = entry.getValue();
            String blockTagStoneVariant = StoneVariantsImpl.getVariantFromStoneVariantTag(stoneVariants, tag);
            if (blockTagStoneVariant == null || (itemTagStoneVariant = (String)itemToStoneVariant.get(item)) != null && blockTagStoneVariant.length() <= itemTagStoneVariant.length()) continue;
            itemToStoneVariant.put(item, blockTagStoneVariant);
        }
        return new StoneVariantsImpl(stoneVariants, itemToStoneVariant);
    }

    private static <T> Map<class_2960, class_6862<T>> mapEntriesToStoneVariantTags(Set<class_6862<T>> stoneVariantTags, VanillaTagWrapper<T> tags) {
        HashMap<class_2960, class_6862<T>> idToStoneVariantTag = new HashMap<class_2960, class_6862<T>>();
        for (class_6862<T> stoneVariantTag : stoneVariantTags) {
            for (class_6880 holder : tags.get(stoneVariantTag)) {
                class_2960 id = ((class_5321)holder.method_40230().orElseThrow(() -> new IllegalStateException("Tag is not bound for holder " + String.valueOf(holder)))).method_29177();
                class_6862<T> oldTag = idToStoneVariantTag.put(id, stoneVariantTag);
                if (oldTag == null) continue;
                AlmostUnifiedCommon.LOGGER.error("{} is bound to multiple stone variant tags: {} and {}", (Object)id, oldTag, stoneVariantTag);
            }
        }
        return idToStoneVariantTag;
    }

    @Nullable
    private static String getVariantFromStoneVariantTag(Collection<String> stoneVariants, class_6862<?> tag) {
        int i;
        String tagString = tag.comp_327().toString();
        String stoneVariant = tagString.substring((i = tagString.lastIndexOf(47)) + 1);
        if (!stoneVariants.contains(stoneVariant)) {
            return null;
        }
        return stoneVariant.equals("stone") ? "" : stoneVariant;
    }

    @Override
    public String getStoneVariant(class_2960 item) {
        return this.itemToStoneVariant.computeIfAbsent(item, this::computeStoneVariant);
    }

    @Override
    public boolean isOreTag(class_6862<class_1792> tag) {
        return this.isOreTagCache.computeIfAbsent(tag, t -> ORE_TAG_PATTERN.matcher(t.comp_327().toString()).matches());
    }

    private static List<String> sortStoneVariants(Collection<String> stoneVariants) {
        return stoneVariants.stream().sorted(Comparator.comparingInt(String::length).reversed()).toList();
    }

    private String computeStoneVariant(class_2960 item) {
        for (String stoneVariant : this.stoneVariants) {
            if (!item.method_12832().contains(stoneVariant + "_") && !item.method_12832().endsWith("_" + stoneVariant)) continue;
            return stoneVariant.equals("stone") ? "" : stoneVariant;
        }
        return "";
    }
}

