package com.almostreliable.unified.unification.recipe;

import com.almostreliable.unified.api.unification.recipe.CustomIngredientUnifier;
import com.almostreliable.unified.api.unification.recipe.CustomIngredientUnifierRegistry;

import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class CustomIngredientUnifierRegistryImpl implements CustomIngredientUnifierRegistry {

    private final Map<class_2960, CustomIngredientUnifier> ingredientUnifiersByType = new HashMap<>();

    @Override
    public void registerForType(class_2960 type, CustomIngredientUnifier customIngredientUnifier) {
        ingredientUnifiersByType.put(type, customIngredientUnifier);
    }

    @Nullable
    @Override
    public CustomIngredientUnifier getCustomIngredientUnifier(class_2960 type) {
        return ingredientUnifiersByType.get(type);
    }
}
