package com.almostreliable.unified.mixin.loot;

import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.unification.loot.LootUnificationHandler;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_55;
import net.minecraft.class_79;

@Mixin(class_55.class)
public class LootPoolMixin implements LootUnificationHandler {

    @Shadow @Final private List<class_79> entries;

    @Override
    public boolean almostunified$unify(UnificationLookup lookup) {
        boolean unified = false;

        for (class_79 entry : this.entries) {
            if (entry instanceof LootUnificationHandler handler) {
                unified |= handler.almostunified$unify(lookup);
            }
        }

        return unified;
    }
}
