/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.config.DebugConfig;
import com.almostreliable.unified.unification.recipe.RecipeLink;
import com.almostreliable.unified.unification.recipe.RecipeTransformer;
import com.almostreliable.unified.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class DebugHandler {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String DUPLICATES = "duplicates.txt";
    private static final String OVERVIEW = "overview.txt";
    private static final String RECIPES_AFTER = "recipes_after.txt";
    private static final String RECIPES_BEFORE = "recipes_before.txt";
    private static final String TAGS = "tags.txt";
    private static final String UNIFICATION = "unification.txt";
    private final Set<class_2960> recipeErrors = new HashSet<class_2960>();
    private final DebugConfig config;
    private final String lastRun;
    private int recipesBefore = -1;
    private long startTime;
    private long endTime;
    @Nullable
    private RecipeTransformer.Result transformerResult;

    public DebugHandler(DebugConfig config) {
        this.config = config;
        this.lastRun = "# Last run: " + DATE_FORMAT.format(new Date(System.currentTimeMillis()));
    }

    public void onRunStart(Map<class_2960, JsonElement> recipes, UnificationLookup unificationLookup) {
        this.dumpTags(unificationLookup);
        this.dumpRecipes(RECIPES_BEFORE, recipes);
        this.recipesBefore = recipes.size();
    }

    public void measure(Supplier<RecipeTransformer.Result> transformerSupplier) {
        this.startTime = System.currentTimeMillis();
        this.transformerResult = transformerSupplier.get();
        this.endTime = System.currentTimeMillis();
    }

    public void onRunEnd(Map<class_2960, JsonElement> recipes) {
        Preconditions.checkArgument((this.recipesBefore >= 0 ? 1 : 0) != 0, (Object)"recipesBefore not set");
        Preconditions.checkArgument((this.startTime > 0L ? 1 : 0) != 0, (Object)"startTime not set");
        Preconditions.checkArgument((this.endTime > 0L ? 1 : 0) != 0, (Object)"endTime not set");
        Preconditions.checkNotNull((Object)this.transformerResult, (Object)"transformerResult not set");
        this.dumpRecipes(RECIPES_AFTER, recipes);
        this.dumpOverview(recipes.size());
        this.dumpUnification();
        this.dumpDuplicates();
    }

    public void collectRecipeError(class_2960 recipeId) {
        Preconditions.checkNotNull((Object)this.transformerResult, (Object)"transformerResult not set");
        if (this.transformerResult.getUnifiedRecipes().contains(recipeId)) {
            this.recipeErrors.add(recipeId);
        }
    }

    public void finish() {
        if (!this.recipeErrors.isEmpty()) {
            AlmostUnifiedCommon.LOGGER.error("The following recipes were unified and threw exceptions when being loaded: {}", this.recipeErrors);
            AlmostUnifiedCommon.LOGGER.warn("Try to add them to the ignore list and if the problem is gone, report it to the Almost Unified developers.");
        }
        this.recipeErrors.clear();
        this.transformerResult = null;
    }

    private void dumpTags(UnificationLookup unificationLookup) {
        if (!this.config.shouldDumpTags()) {
            return;
        }
        int maxLength = DebugHandler.getMaxLength(unificationLookup.getTags(), t -> t.comp_327().toString().length());
        FileUtils.writeDebugLog(TAGS, sb -> sb.append(this.lastRun).append("\n").append(unificationLookup.getTags().stream().map(t -> DebugHandler.rf(t.comp_327(), maxLength) + " => " + unificationLookup.getTagEntries((class_6862<class_1792>)t).stream().map(entry -> entry.id().toString()).sorted().collect(Collectors.joining(", ")) + "\n").sorted().collect(Collectors.joining())));
    }

    private void dumpRecipes(String fileName, Map<class_2960, JsonElement> recipes) {
        if (!this.config.shouldDumpRecipes()) {
            return;
        }
        int maxLength = DebugHandler.getMaxLength(recipes.keySet(), id -> id.toString().length());
        FileUtils.writeDebugLog(fileName, sb -> sb.append(this.lastRun).append("\n").append(recipes.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> DebugHandler.rf(e.getKey(), maxLength) + " => " + ((JsonElement)e.getValue()).toString()).collect(Collectors.joining("\n"))));
    }

    private void dumpOverview(int recipesAfter) {
        if (!this.config.shouldDumpOverview()) {
            return;
        }
        assert (this.transformerResult != null);
        int maxLength = DebugHandler.getMaxLength(this.transformerResult.getUnifiedRecipeTypes(), t -> t.toString().length());
        FileUtils.writeDebugLog(OVERVIEW, sb -> {
            sb.append(this.lastRun).append("\n").append("# Statistics:\n").append("- Unified Recipes: ").append(this.transformerResult.getUnifiedRecipesCount()).append("\n").append("- Duplicate Recipes: ").append(this.transformerResult.getDuplicateRecipesCount()).append(" (Individual: ").append(this.transformerResult.getTotalDuplicateRecipesCount()).append(")\n").append("- Recipes Before: ").append(this.recipesBefore).append("\n").append("- Recipes After: ").append(recipesAfter).append("\n").append("- Elapsed Time: ").append(this.endTime - this.startTime).append(" ms").append("\n\n").append("# Summary:\n").append(DebugHandler.rf("Recipe type", maxLength)).append(" | ").append(this.lf("Unified", 10)).append(" | ").append(this.lf("Duplicates", 10)).append(" | ").append(this.lf("All", 5)).append("\n").append(StringUtils.repeat((String)"-", (int)(maxLength + 10 + 10 + 5 + 9))).append("\n");
            this.getSortedUnifiedRecipeTypes().forEach(type -> {
                int unifiedSize = this.transformerResult.getUnifiedRecipesByType((class_2960)type).size();
                int allSize = this.transformerResult.getRecipesByType((class_2960)type).size();
                int duplicatesSize = this.transformerResult.getDuplicateRecipesByType((class_2960)type).size();
                int individualDuplicatesSize = this.transformerResult.getDuplicateRecipesByType((class_2960)type).stream().mapToInt(l -> l.getRecipes().size()).sum();
                String dStr = String.format("%s (%s)", this.lf(duplicatesSize, 3), this.lf(individualDuplicatesSize, 3));
                sb.append(DebugHandler.rf(type, maxLength)).append(" | ").append(this.lf(unifiedSize, 10)).append(" | ").append(this.lf(duplicatesSize == 0 ? " " : dStr, 10)).append(" | ").append(this.lf(allSize, 5)).append("\n");
            });
        });
    }

    private void dumpUnification() {
        if (!this.config.shouldDumpUnification()) {
            return;
        }
        FileUtils.writeDebugLog(UNIFICATION, sb -> {
            sb.append(this.lastRun).append("\n");
            this.getSortedUnifiedRecipeTypes().forEach(type -> {
                sb.append(type.toString()).append(" {\n");
                this.getSortedUnifiedRecipes((class_2960)type).forEach(recipe -> sb.append("\t- ").append(recipe.getId()).append("\n").append("\t\t    Original: ").append(recipe.getOriginal()).append("\n").append("\t\t Transformed: ").append(recipe.getUnified() == null ? "NOT UNIFIED" : recipe.getUnified().toString()).append("\n\n"));
                sb.append("}\n\n");
            });
        });
    }

    private void dumpDuplicates() {
        if (!this.config.shouldDumpDuplicates()) {
            return;
        }
        assert (this.transformerResult != null);
        FileUtils.writeDebugLog(DUPLICATES, sb -> {
            sb.append(this.lastRun).append("\n");
            this.getSortedUnifiedRecipeTypes().forEach(type -> {
                List<RecipeLink.DuplicateLink> duplicates = this.transformerResult.getDuplicateRecipesByType((class_2960)type).stream().sorted(Comparator.comparing(l -> l.getMaster().getId().toString())).toList();
                if (duplicates.isEmpty()) {
                    return;
                }
                sb.append(duplicates.stream().map(this::createDuplicatesDump).collect(Collectors.joining("", String.valueOf(type) + " {\n", "}\n\n")));
            });
        });
    }

    private String createDuplicatesDump(RecipeLink.DuplicateLink link) {
        return link.getRecipes().stream().sorted(Comparator.comparing(r -> r.getId().toString())).map(r -> "\t\t- " + String.valueOf(r.getId()) + "\n").collect(Collectors.joining("", String.format("\t%s\n", link.getMaster().getId()), "\n"));
    }

    private static <T> int getMaxLength(Collection<T> collection, ToIntFunction<T> function) {
        return collection.stream().mapToInt(function).max().orElse(0);
    }

    private static String rf(Object v, int size) {
        return StringUtils.rightPad((String)v.toString(), (int)size);
    }

    private String lf(Object v, int size) {
        return StringUtils.leftPad((String)v.toString(), (int)size);
    }

    private Stream<class_2960> getSortedUnifiedRecipeTypes() {
        Preconditions.checkNotNull((Object)this.transformerResult);
        return this.transformerResult.getUnifiedRecipeTypes().stream().sorted(Comparator.comparing(class_2960::toString));
    }

    private Stream<RecipeLink> getSortedUnifiedRecipes(class_2960 type) {
        Preconditions.checkNotNull((Object)this.transformerResult);
        return this.transformerResult.getUnifiedRecipesByType(type).stream().sorted(Comparator.comparing(r -> r.getId().toString()));
    }
}

