/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.recipe;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.UnificationSettings;
import com.almostreliable.unified.api.unification.recipe.CustomIngredientUnifierRegistry;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifierRegistry;
import com.almostreliable.unified.compat.viewer.ClientRecipeTracker;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.DuplicateConfig;
import com.almostreliable.unified.unification.UnificationSettingsImpl;
import com.almostreliable.unified.unification.recipe.RecipeJsonImpl;
import com.almostreliable.unified.unification.recipe.RecipeLink;
import com.almostreliable.unified.unification.recipe.UnificationHelperImpl;
import com.almostreliable.unified.utils.JsonCompare;
import com.almostreliable.unified.utils.RecipeTypePropertiesLogger;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class RecipeTransformer {
    private final CustomIngredientUnifierRegistry ingredientUnifierRegistry;
    private final RecipeUnifierRegistry recipeUnifierRegistry;
    private final Collection<? extends UnificationSettings> unificationSettings;
    private final DuplicateConfig duplicateConfig;
    private final RecipeTypePropertiesLogger propertiesLogger = new RecipeTypePropertiesLogger();

    public RecipeTransformer(CustomIngredientUnifierRegistry ingredientUnifierRegistry, RecipeUnifierRegistry recipeUnifierRegistry, Collection<? extends UnificationSettings> unificationSettings) {
        this.ingredientUnifierRegistry = ingredientUnifierRegistry;
        this.recipeUnifierRegistry = recipeUnifierRegistry;
        this.unificationSettings = unificationSettings;
        this.duplicateConfig = Config.load("duplicates", DuplicateConfig.SERIALIZER);
    }

    public Result transformRecipes(Map<class_2960, JsonElement> recipes) {
        Stopwatch transformationTimer = Stopwatch.createStarted();
        AlmostUnifiedCommon.LOGGER.info("Recipe count: {}", (Object)recipes.size());
        ClientRecipeTracker.RawBuilder tracker = AlmostUnifiedCommon.STARTUP_CONFIG.isServerOnly() ? null : new ClientRecipeTracker.RawBuilder();
        Result result = new Result();
        Map<class_2960, List<RecipeLink>> byType = this.groupRecipesByType(recipes);
        byType.forEach((type, recipeLinks) -> {
            this.transformRecipes((List<RecipeLink>)recipeLinks, recipes, tracker);
            result.addAll((Collection<RecipeLink>)recipeLinks);
        });
        AlmostUnifiedCommon.LOGGER.info("Recipe count afterwards: {} (done in {})", (Object)recipes.size(), (Object)transformationTimer.stop());
        for (UnificationSettings unificationSettings : this.unificationSettings) {
            ((UnificationSettingsImpl)unificationSettings).clearCache();
        }
        this.duplicateConfig.clearCache();
        if (tracker != null) {
            recipes.putAll(tracker.compute());
        }
        return result;
    }

    private void transformRecipes(List<RecipeLink> recipeLinks, Map<class_2960, JsonElement> allRecipes, @Nullable ClientRecipeTracker.RawBuilder tracker) {
        LinkedHashSet<RecipeLink> unified = this.unifyRecipes(recipeLinks, r -> allRecipes.put(r.getId(), (JsonElement)r.getUnified()));
        Set<RecipeLink.DuplicateLink> duplicates = this.handleDuplicates(this.duplicateConfig.shouldCompareAll() ? recipeLinks : unified, recipeLinks);
        duplicates.stream().flatMap(d -> d.getRecipesWithoutMaster().stream()).forEach(r -> allRecipes.remove(r.getId()));
        if (tracker != null) {
            unified.forEach(tracker::add);
        }
    }

    public Map<class_2960, List<RecipeLink>> groupRecipesByType(Map<class_2960, JsonElement> recipes) {
        return recipes.entrySet().stream().filter(entry -> {
            JsonObject jsonObject;
            Object patt0$temp = entry.getValue();
            return patt0$temp instanceof JsonObject && !(jsonObject = (JsonObject)patt0$temp).isEmpty();
        }).map(entry -> RecipeLink.of((class_2960)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject())).filter(Objects::nonNull).sorted(Comparator.comparing(entry -> entry.getId().toString())).collect(Collectors.groupingByConcurrent(RecipeLink::getType));
    }

    private Set<RecipeLink.DuplicateLink> handleDuplicates(Collection<RecipeLink> recipeLinks, List<RecipeLink> linksToCompare) {
        HashSet<RecipeLink.DuplicateLink> duplicates = new HashSet<RecipeLink.DuplicateLink>(recipeLinks.size());
        for (RecipeLink recipeLink : recipeLinks) {
            if (!this.handleDuplicate(recipeLink, linksToCompare) || recipeLink.getDuplicateLink() == null) continue;
            duplicates.add(recipeLink.getDuplicateLink());
        }
        return duplicates;
    }

    private boolean handleDuplicate(RecipeLink curRecipe, List<RecipeLink> recipes) {
        if (this.duplicateConfig.shouldIgnoreRecipe(curRecipe)) {
            return false;
        }
        JsonCompare.CompareContext compareContext = this.duplicateConfig.getCompareContext(curRecipe);
        boolean foundDuplicate = false;
        for (RecipeLink recipeLink : recipes) {
            if (!curRecipe.getType().equals((Object)recipeLink.getType())) {
                throw new IllegalStateException("Recipe types do not match for " + String.valueOf(curRecipe.getId()) + " and " + String.valueOf(recipeLink.getId()));
            }
            if (recipeLink == curRecipe || this.duplicateConfig.shouldIgnoreRecipe(recipeLink)) continue;
            foundDuplicate |= curRecipe.handleDuplicate(recipeLink, compareContext);
        }
        return foundDuplicate;
    }

    private LinkedHashSet<RecipeLink> unifyRecipes(List<RecipeLink> recipeLinks, Consumer<RecipeLink> onUnified) {
        LinkedHashSet<RecipeLink> unified = new LinkedHashSet<RecipeLink>(recipeLinks.size());
        for (RecipeLink recipeLink : recipeLinks) {
            this.unifyRecipe(recipeLink);
            if (!recipeLink.isUnified()) continue;
            onUnified.accept(recipeLink);
            unified.add(recipeLink);
        }
        return unified;
    }

    public void unifyRecipe(RecipeLink recipe) {
        try {
            JsonObject recipeCopy = recipe.getOriginal().deepCopy();
            RecipeJsonImpl json = new RecipeJsonImpl(recipe.getId(), recipeCopy);
            for (UnificationSettings unificationSettings : this.unificationSettings) {
                if (!unificationSettings.shouldIncludeRecipe(recipe)) continue;
                UnificationHelperImpl helper = new UnificationHelperImpl(this.ingredientUnifierRegistry, unificationSettings);
                RecipeUnifier unifier = this.recipeUnifierRegistry.getRecipeUnifier(recipe);
                unifier.unify(helper, json);
            }
            if (!recipe.getOriginal().equals((Object)recipeCopy)) {
                recipe.setUnified(recipeCopy);
            }
            this.propertiesLogger.log(recipe.getType(), recipe.getOriginal());
        }
        catch (Exception e) {
            AlmostUnifiedCommon.LOGGER.error("Error unifying recipe '{}'", (Object)recipe.getId(), (Object)e);
        }
    }

    public static class Result {
        private final Multimap<class_2960, RecipeLink> allRecipesByType = HashMultimap.create();
        private final Multimap<class_2960, RecipeLink> unifiedRecipesByType = HashMultimap.create();
        private final Multimap<class_2960, RecipeLink.DuplicateLink> duplicatesByType = HashMultimap.create();
        @Nullable
        private Set<class_2960> unifiedRecipeIds;

        private void add(RecipeLink link) {
            if (this.allRecipesByType.containsEntry((Object)link.getType(), (Object)link)) {
                throw new IllegalStateException("already tracking recipe type " + String.valueOf(link.getType()));
            }
            this.allRecipesByType.put((Object)link.getType(), (Object)link);
            if (link.isUnified()) {
                this.unifiedRecipesByType.put((Object)link.getType(), (Object)link);
            }
            if (link.hasDuplicateLink()) {
                this.duplicatesByType.put((Object)link.getType(), (Object)link.getDuplicateLink());
            }
        }

        private void addAll(Collection<RecipeLink> links) {
            links.forEach(this::add);
        }

        public Collection<RecipeLink> getRecipesByType(class_2960 type) {
            return Collections.unmodifiableCollection(this.allRecipesByType.get((Object)type));
        }

        public Collection<class_2960> getUnifiedRecipes() {
            if (this.unifiedRecipeIds == null) {
                this.unifiedRecipeIds = this.unifiedRecipesByType.values().stream().map(RecipeLink::getId).collect(Collectors.toSet());
            }
            return this.unifiedRecipeIds;
        }

        public Collection<RecipeLink> getUnifiedRecipesByType(class_2960 type) {
            return Collections.unmodifiableCollection(this.unifiedRecipesByType.get((Object)type));
        }

        public Collection<RecipeLink.DuplicateLink> getDuplicateRecipesByType(class_2960 type) {
            return Collections.unmodifiableCollection(this.duplicatesByType.get((Object)type));
        }

        public int getUnifiedRecipesCount() {
            return this.unifiedRecipesByType.size();
        }

        public int getDuplicateRecipesCount() {
            return this.duplicatesByType.size();
        }

        public int getTotalDuplicateRecipesCount() {
            return this.duplicatesByType.values().stream().mapToInt(l -> l.getRecipes().size()).sum();
        }

        public Set<class_2960> getUnifiedRecipeTypes() {
            return this.unifiedRecipesByType.keySet();
        }
    }
}

