/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.loot;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.unification.UnificationSettings;
import com.almostreliable.unified.unification.loot.LootUnificationHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public final class LootUnification {
    private LootUnification() {
    }

    public static void unifyLoot(AlmostUnifiedRuntime runtime, class_7225.class_7874 registries) {
        try {
            Collection<? extends UnificationSettings> handlers = runtime.getUnificationSettings();
            boolean enableLootUnification = handlers.stream().anyMatch(UnificationSettings::shouldUnifyLoot);
            if (!enableLootUnification) {
                return;
            }
            class_7225.class_7226 lootTableRegistry = registries.method_46762(class_7924.field_50079);
            lootTableRegistry.method_42017().forEach(holder -> LootUnification.unifyLoot((class_52)holder.comp_349(), holder.method_40237().method_29177(), handlers));
        }
        catch (Exception e) {
            AlmostUnifiedCommon.LOGGER.error("Failed to unify loot", (Throwable)e);
        }
    }

    public static void unifyLoot(class_52 lootTable, class_2960 tableId, Collection<? extends UnificationSettings> unificationSettings) {
        LootUnificationHandler lootUnificationHandler = LootUnificationHandler.cast(lootTable);
        HashSet<UnificationSettings> modifiedTable = new HashSet<UnificationSettings>();
        for (UnificationSettings unificationSettings2 : unificationSettings) {
            if (!unificationSettings2.shouldUnifyLoot() || !unificationSettings2.shouldIncludeLootTable(tableId) || !lootUnificationHandler.almostunified$unify(unificationSettings2)) continue;
            modifiedTable.add(unificationSettings2);
        }
        if (!modifiedTable.isEmpty()) {
            AlmostUnifiedCommon.LOGGER.info("Loot table '{}' was unified by: {}", (Object)tableId, (Object)modifiedTable.stream().map(UnificationSettings::getName).collect(Collectors.joining(", ")));
        }
    }
}

