/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.TagSubstitutions;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class TagSubstitutionsImpl
implements TagSubstitutions {
    private final Map<class_6862<class_1792>, class_6862<class_1792>> replacedToSubstitute;
    private final Multimap<class_6862<class_1792>, class_6862<class_1792>> substituteToReplaced;

    private TagSubstitutionsImpl(Map<class_6862<class_1792>, class_6862<class_1792>> replacedToSubstitute, Multimap<class_6862<class_1792>, class_6862<class_1792>> substituteToReplaced) {
        this.replacedToSubstitute = replacedToSubstitute;
        this.substituteToReplaced = substituteToReplaced;
    }

    public static TagSubstitutionsImpl create(Predicate<class_6862<class_1792>> validTagFilter, Predicate<class_6862<class_1792>> unifyTagFilter, Map<class_2960, Set<class_2960>> configuredSubstitutes) {
        ImmutableMap.Builder refsToSubsBuilder = ImmutableMap.builder();
        ImmutableMultimap.Builder subsToRefsBuilder = ImmutableMultimap.builder();
        HashSet invalidReplacedTags = new HashSet();
        HashSet unifyReplacedTags = new HashSet();
        configuredSubstitutes.forEach((rawSubstituteTag, rawReplacedTags) -> {
            for (class_2960 rawReplacedTag : rawReplacedTags) {
                class_6862 substituteTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)rawSubstituteTag);
                class_6862 replacedTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)rawReplacedTag);
                if (!unifyTagFilter.test(substituteTag)) {
                    AlmostUnifiedCommon.LOGGER.warn("[TagSubstitutions] Substitute tag '#{}' is not configured as a unify tag! Config entry '#{} -> {}' will be ignored.", (Object)substituteTag.comp_327(), (Object)substituteTag.comp_327(), (Object)rawReplacedTags.stream().map(t -> "#" + String.valueOf(t)).collect(Collectors.joining(", ")));
                    return;
                }
                if (!validTagFilter.test(replacedTag)) {
                    invalidReplacedTags.add(replacedTag);
                    continue;
                }
                if (unifyTagFilter.test(replacedTag)) {
                    unifyReplacedTags.add(replacedTag);
                    continue;
                }
                refsToSubsBuilder.put((Object)replacedTag, (Object)substituteTag);
                subsToRefsBuilder.put((Object)substituteTag, (Object)replacedTag);
            }
            if (!invalidReplacedTags.isEmpty()) {
                AlmostUnifiedCommon.LOGGER.warn("[TagSubstitutions] Substitute tag '#{}' contains invalid replaced tags! Affected tags: {}", rawSubstituteTag, (Object)invalidReplacedTags.stream().map(t -> "#" + String.valueOf(t.comp_327())).collect(Collectors.joining(", ")));
            }
            if (!unifyReplacedTags.isEmpty()) {
                AlmostUnifiedCommon.LOGGER.warn("[TagSubstitutions] Substitute tag '#{}' contains replaced tags that are configured as unify tags! Affected tags: {}", rawSubstituteTag, (Object)unifyReplacedTags.stream().map(t -> "#" + String.valueOf(t.comp_327())).collect(Collectors.joining(", ")));
            }
        });
        return new TagSubstitutionsImpl((Map<class_6862<class_1792>, class_6862<class_1792>>)refsToSubsBuilder.build(), (Multimap<class_6862<class_1792>, class_6862<class_1792>>)subsToRefsBuilder.build());
    }

    public void apply(VanillaTagWrapper<class_1792> itemTags) {
        HashMultimap changedTags = HashMultimap.create();
        this.substituteToReplaced.asMap().forEach((arg_0, arg_1) -> TagSubstitutionsImpl.lambda$apply$5(itemTags, (Multimap)changedTags, arg_0, arg_1));
        changedTags.asMap().forEach((tag, entries) -> AlmostUnifiedCommon.LOGGER.info("[TagSubstitutions] Added items of replaced tags to substitute tag '#{}'. Added items: {}", tag, entries));
    }

    @Override
    @Nullable
    public class_6862<class_1792> getSubstituteTag(class_6862<class_1792> replacedTag) {
        return this.replacedToSubstitute.get(replacedTag);
    }

    @Override
    public Collection<class_6862<class_1792>> getReplacedTags(class_6862<class_1792> substituteTag) {
        return Collections.unmodifiableCollection(this.substituteToReplaced.get(substituteTag));
    }

    @Override
    public Set<class_6862<class_1792>> getReplacedTags() {
        return this.replacedToSubstitute.keySet();
    }

    private static /* synthetic */ void lambda$apply$5(VanillaTagWrapper itemTags, Multimap changedTags, class_6862 substituteTag, Collection replacedTags) {
        for (class_6862 replacedTag : replacedTags) {
            Collection replacedTagHolders = itemTags.get(replacedTag.comp_327());
            for (class_6880 replacedTagHolder : replacedTagHolders) {
                itemTags.add(substituteTag.comp_327(), replacedTagHolder);
                replacedTagHolder.method_40230().ifPresent(key -> changedTags.put((Object)substituteTag.comp_327(), (Object)key.method_29177()));
            }
        }
    }
}

