/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.core;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class TagReloadHandler {
    private static final Object LOCK = new Object();
    @Nullable
    private static VanillaTagWrapper<class_1792> VANILLA_ITEM_TAGS;
    @Nullable
    private static VanillaTagWrapper<class_2248> VANILLA_BLOCK_TAGS;

    private TagReloadHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initItemTags(Map<class_2960, Collection<class_6880<class_1792>>> rawItemTags) {
        Object object = LOCK;
        synchronized (object) {
            VANILLA_ITEM_TAGS = VanillaTagWrapper.of(class_7923.field_41178, rawItemTags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initBlockTags(Map<class_2960, Collection<class_6880<class_2248>>> rawBlockTags) {
        Object object = LOCK;
        synchronized (object) {
            VANILLA_BLOCK_TAGS = VanillaTagWrapper.of(class_7923.field_41175, rawBlockTags);
        }
    }

    public static void run() {
        if (VANILLA_ITEM_TAGS == null || VANILLA_BLOCK_TAGS == null) {
            return;
        }
        AlmostUnifiedCommon.onTagLoaderReload(VANILLA_ITEM_TAGS, VANILLA_BLOCK_TAGS);
        VANILLA_ITEM_TAGS.seal();
        VANILLA_BLOCK_TAGS.seal();
        VANILLA_ITEM_TAGS = null;
        VANILLA_BLOCK_TAGS = null;
    }

    public static void applyCustomTags(Map<class_2960, Set<class_2960>> customTags, VanillaTagWrapper<class_1792> itemTags) {
        HashMultimap changedItemTags = HashMultimap.create();
        for (Map.Entry<class_2960, Set<class_2960>> entry : customTags.entrySet()) {
            class_2960 tag2 = entry.getKey();
            Set<class_2960> itemIds = entry.getValue();
            for (class_2960 itemId : itemIds) {
                if (!class_7923.field_41178.method_10250(itemId)) {
                    AlmostUnifiedCommon.LOGGER.warn("[CustomTags] Custom tag '{}' contains invalid item '{}'", (Object)tag2, (Object)itemId);
                    continue;
                }
                class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)itemId);
                class_6880 itemHolder = class_7923.field_41178.method_40264(itemKey).orElse(null);
                if (itemHolder == null) continue;
                Collection<class_6880<class_1792>> currentHolders = itemTags.get(tag2);
                if (!currentHolders.isEmpty() && currentHolders.contains(itemHolder)) {
                    AlmostUnifiedCommon.LOGGER.warn("[CustomTags] Custom tag '{}' already contains item '{}'", (Object)tag2, (Object)itemId);
                    continue;
                }
                itemTags.add(tag2, (class_6880<class_1792>)itemHolder);
                changedItemTags.put((Object)tag2, (Object)itemId);
            }
        }
        if (!changedItemTags.isEmpty()) {
            changedItemTags.asMap().forEach((tag, items) -> AlmostUnifiedCommon.LOGGER.info("[CustomTags] Modified tag '#{}', added {}", tag, items));
        }
    }
}

