/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.viewer;

import com.almostreliable.unified.compat.viewer.CRTLookup;
import com.almostreliable.unified.compat.viewer.ClientRecipeTracker;
import com.almostreliable.unified.compat.viewer.ItemHider;
import com.almostreliable.unified.compat.viewer.RecipeIndicator;
import com.almostreliable.unified.utils.Utils;
import java.util.ArrayList;
import java.util.stream.Stream;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@REIPluginCompatIgnore
@JeiPlugin
public class AlmostJEI
implements IModPlugin {
    public class_2960 getPluginUid() {
        return Utils.getRL("jei");
    }

    public void onRuntimeAvailable(IJeiRuntime jei) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_6880 itemHolder : class_7923.field_41178.method_40286(ItemHider.HIDE_TAG)) {
            items.add(new class_1799(itemHolder));
        }
        if (!items.isEmpty()) {
            jei.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, items);
        }
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        Stream recipeTypes = registration.getJeiHelpers().getAllRecipeTypes();
        recipeTypes.forEach(rt -> registration.addRecipeCategoryDecorator(rt, new Decorator()));
    }

    private static class Decorator<T>
    implements IRecipeCategoryDecorator<T> {
        private static final int RECIPE_BORDER_PADDING = 4;

        private Decorator() {
        }

        public void draw(T recipe, IRecipeCategory<T> recipeCategory, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
            ClientRecipeTracker.ClientRecipeLink recipeLink = Decorator.resolveLink(recipeCategory, recipe);
            if (recipeLink == null) {
                return;
            }
            int pX = recipeCategory.getWidth() + 8 - 10;
            int pY = recipeCategory.getHeight() + 8 - 10;
            RecipeIndicator.renderIndicator(guiGraphics, pX, pY, 10);
            if (mouseX >= (double)pX && mouseX <= (double)(pX + 10) && mouseY >= (double)pY && mouseY <= (double)(pY + 10)) {
                RecipeIndicator.renderTooltip(guiGraphics, recipeLink, mouseX, mouseY);
            }
        }

        @Nullable
        private static <R> ClientRecipeTracker.ClientRecipeLink resolveLink(IRecipeCategory<R> recipeCategory, R recipe) {
            class_2960 recipeId = recipeCategory.getRegistryName(recipe);
            if (recipeId == null) {
                return null;
            }
            return CRTLookup.getLink(recipeId);
        }
    }
}

