package com.almostreliable.unified.api.recipe;

import com.almostreliable.unified.utils.UnifyTag;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import java.util.function.Predicate;

public interface RecipeContext {

    @Nullable
    class_2960 getReplacementForItem(@Nullable class_2960 item);

    @Nullable
    class_2960 getPreferredItemForTag(@Nullable UnifyTag<class_1792> tag, Predicate<class_2960> filter);

    @Nullable
    UnifyTag<class_1792> getPreferredTagForItem(@Nullable class_2960 item);

    @Nullable
    JsonElement createIngredientReplacement(@Nullable JsonElement element);

    @Nullable
    JsonElement createIngredientReplacement(@Nullable JsonElement element, String... lookupKeys);

    @Nullable
    JsonElement createResultReplacement(@Nullable JsonElement element);

    @Nullable
    JsonElement createResultReplacement(@Nullable JsonElement element, boolean includeTagCheck, String... lookupKeys);

    class_2960 getType();

    boolean hasProperty(String property);

    default String getModId() {
        return getType().method_12836();
    }
}
