/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public class TagOwnerships {
    private final Map<UnifyTag<class_1792>, UnifyTag<class_1792>> refsToOwner;
    private final Multimap<UnifyTag<class_1792>, UnifyTag<class_1792>> ownerToRefs;

    public TagOwnerships(Set<UnifyTag<class_1792>> unifyTags, Map<class_2960, Set<class_2960>> tagOwnershipConfig) {
        ImmutableMap.Builder refsToOwnerBuilder = ImmutableMap.builder();
        ImmutableMultimap.Builder ownerToRefsBuilder = ImmutableMultimap.builder();
        tagOwnershipConfig.forEach((rawOwner, rawRefs) -> {
            for (class_2960 rawRef : rawRefs) {
                UnifyTag<class_1792> owner = UnifyTag.item(rawOwner);
                UnifyTag<class_1792> ref = UnifyTag.item(rawRef);
                if (!unifyTags.contains(owner)) {
                    AlmostUnified.LOG.warn("[TagOwnerships] Owner tag '#{}' is not present in the unify tag list!", (Object)owner.location());
                    continue;
                }
                if (unifyTags.contains(ref)) {
                    AlmostUnified.LOG.warn("[TagOwnerships] Reference tag '#{}' of owner tag '#{}' is present in the unify tag list!", (Object)ref.location(), (Object)owner.location());
                    continue;
                }
                refsToOwnerBuilder.put(ref, owner);
                ownerToRefsBuilder.put(owner, ref);
            }
        });
        this.refsToOwner = refsToOwnerBuilder.build();
        this.ownerToRefs = ownerToRefsBuilder.build();
    }

    public void applyOwnerships(Map<class_2960, Collection<class_6880<class_1792>>> rawTags) {
        HashMultimap changedTags = HashMultimap.create();
        this.ownerToRefs.asMap().forEach((arg_0, arg_1) -> TagOwnerships.lambda$applyOwnerships$2(rawTags, (Multimap)changedTags, arg_0, arg_1));
        if (!changedTags.isEmpty()) {
            changedTags.asMap().forEach((tag, items) -> AlmostUnified.LOG.info("[TagOwnerships] Modified tag '#{}', added {}", tag, items));
        }
    }

    @Nullable
    public UnifyTag<class_1792> getOwnerByTag(UnifyTag<class_1792> tag) {
        return this.refsToOwner.get(tag);
    }

    public Collection<UnifyTag<class_1792>> getRefsByOwner(UnifyTag<class_1792> tag) {
        return this.ownerToRefs.get(tag);
    }

    private static /* synthetic */ void lambda$applyOwnerships$2(Map rawTags, Multimap changedTags, UnifyTag owner, Collection refs) {
        Collection rawHolders = (Collection)rawTags.get(owner.location());
        if (rawHolders == null) {
            AlmostUnified.LOG.warn("[TagOwnerships] Owner tag '#{}' does not exist!", (Object)owner.location());
            return;
        }
        ImmutableSet.Builder holders = ImmutableSet.builder();
        holders.addAll((Iterable)rawHolders);
        boolean changed = false;
        for (UnifyTag ref : refs) {
            Collection refHolders = (Collection)rawTags.get(ref.location());
            if (refHolders == null) {
                AlmostUnified.LOG.warn("[TagOwnerships] Reference tag '#{}' of owner tag '#{}' does not exist!", (Object)ref.location(), (Object)owner.location());
                continue;
            }
            for (class_6880 holder : refHolders) {
                holders.add((Object)holder);
                holder.method_40230().ifPresent(key -> changedTags.put((Object)owner.location(), (Object)key.method_29177()));
                changed = true;
            }
        }
        if (changed) {
            rawTags.put(owner.location(), holders.build());
        }
    }
}

