package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import com.almostreliable.unified.utils.Utils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class HideHelper {

    private HideHelper() {}

    public static Multimap<UnifyTag<class_1792>, class_2960> createHidingMap() {
        AlmostUnifiedRuntime runtime = AlmostUnified.getRuntime();
        ReplacementMap repMap = runtime.getReplacementMap().orElse(null);
        var tagMap = runtime.getFilteredTagMap().orElse(null);

        Multimap<UnifyTag<class_1792>, class_2960> hidingMap = HashMultimap.create();
        if (repMap == null || tagMap == null) return hidingMap;
        TagOwnerships ownerships = repMap.getTagOwnerships();

        for (var unifyTag : tagMap.getTags()) {
            var itemsByTag = tagMap.getEntriesByTag(unifyTag);
            if (Utils.allSameNamespace(itemsByTag)) continue;

            // it's not enough to exclude the preferred item from hiding because it would hide stone stratas
            Set<class_2960> replacements = new HashSet<>();
            for (class_2960 item : itemsByTag) {
                class_2960 replacement = repMap.getReplacementForItem(item);
                replacements.add(replacement == null ? item : replacement);
            }

            Set<class_2960> itemsToHide = getItemsToHide(unifyTag, itemsByTag, replacements);
            if (itemsToHide != null) {
                hidingMap.putAll(unifyTag, itemsToHide);
            }

            Set<class_2960> refItemsToHide = getRefItemsToHide(unifyTag, ownerships, replacements);
            if (!refItemsToHide.isEmpty()) {
                hidingMap.putAll(unifyTag, refItemsToHide);
            }
        }

        return hidingMap;
    }

    @Nullable
    private static Set<class_2960> getItemsToHide(UnifyTag<class_1792> unifyTag, Set<class_2960> itemsByTag, Set<class_2960> replacements) {
        Set<class_2960> itemsToHide = new HashSet<>();
        for (class_2960 item : itemsByTag) {
            if (!replacements.contains(item)) {
                itemsToHide.add(item);
            }
        }

        if (itemsToHide.isEmpty()) return null;

        AlmostUnified.LOG.info(
                "[AutoHiding] Hiding {}/{} items for tag '#{}' -> {}",
                itemsToHide.size(),
                itemsByTag.size(),
                unifyTag.location(),
                itemsToHide
        );
        return itemsToHide;
    }

    private static Set<class_2960> getRefItemsToHide(UnifyTag<class_1792> unifyTag, TagOwnerships ownerships, Set<class_2960> replacements) {
        var refTags = ownerships.getRefsByOwner(unifyTag);
        Set<class_2960> refItemsToHide = new HashSet<>();

        for (var refTag : refTags) {
            var asTagKey = class_6862.method_40092(class_7924.field_41197, refTag.location());

            class_7923.field_41178.method_40286(asTagKey).forEach(holder -> {
                class_2960 item = class_7923.field_41178.method_10221(holder.comp_349());
                if (replacements.contains(item)) return;
                refItemsToHide.add(item);
            });

            if (refItemsToHide.isEmpty()) continue;

            AlmostUnified.LOG.info(
                    "[AutoHiding] Hiding reference tag '#{}' of owner tag '#{}' -> {}",
                    refTag.location(),
                    unifyTag.location(),
                    refItemsToHide
            );
        }

        return refItemsToHide;
    }

    public static Collection<class_1799> getStacksToHide() {
        var hidingMap = createHidingMap();
        if (hidingMap.isEmpty()) return List.of();

        return hidingMap
                .entries()
                .stream()
                .flatMap(rl -> class_7923.field_41178.method_17966(rl.getValue()).stream())
                .map(class_1799::new)
                .toList();
    }
}
